/*********************************************************************************
    UndoHistory for InDesign CS2. Written by Matevz Bradac (matevzb@email.si),
    this source is free for any (ab)use.
    Modified by Harbs for CS3.
    This script displays a simple dialog with undo history in a dropdown control.
    It is a bit like the History plugin, but not as fancy (but then again, not as
    commercial either).
    When OK is clicked, all the actions from the last to the selected one are undone.
    Same principle could be applied to show the redo history.

 *********************************************************************************/
(function() {
#include HarbsUI.jsx
var kAppVersion = parseFloat(app.version);
var i;
var document;
var reverseUndoHistory;
var historySize;
var dlg, column, row, dropdown;

if (app.documents.length == 0){alert ("No open documents.", "Undo history");exit ()}
document = app.activeDocument;
if (!document.undoHistory || document.undoHistory.length == 0)
{alert ("No undo history.", "Undo history");exit ()}
// undo history is in reverse order (last action first on the list), but we prefer it the other way around
if (document.undoHistory.length>50){
	historySize = 50;
	}else{
	historySize = document.undoHistory.length;
	}
reverseUndoHistory = new Array (historySize);
for (i=historySize-1; i >= 0; i--){
	reverseUndoHistory[(historySize-1) - i] = document.undoHistory[i];
	}
// create the dialog
if(kAppVersion<5){
	dlg = app.dialogs.add ({name:"Undo history", canCancel:true});
	column = dlg.dialogColumns.add ();
	row = column.dialogRows.add ();
	dropdown = row.dropdowns.add ({stringList:reverseUndoHistory, selectedIndex:reverseUndoHistory.length-1});
	}
else{
	dlg = new HarbsUI.DropDownDialog('Undo History',undefined,reverseUndoHistory,reverseUndoHistory.length-1);
	dlg.dropdown.active = true;
	}
if (dlg.show ()){
	if(kAppVersion<5){
		var index = dropdown.selectedIndex;
		}
	else{
		var index = dlg.dropdown.selection.index;
		}
	// user clicked OK -> undo up to the selected undo state
	var numUndos = historySize - index;
	for (i=0; i < numUndos; i++){
		document.undo ();
		}
	}
if(kAppVersion<5){dlg.destroy ();}
} )();