HarbsUI = {};
HarbsUI.IntegerEditBox = function(container,width,initialValue,minValue,maxValue){
	this.width = width || 50;
	this.initialValue = initialValue || 0;
	this.minValue = minValue || 0;
	this.maxValue = maxValue || 100;
	this.text = this.initialValue;
	var editBox = container.add("edittext", undefined, this.initialValue );
	editBox.preferredSize.width = width;
	editBox.widget = this;
	editBox.onChanging = function() {
		if ( this.text.length > 1 ) {
			if ( isNaN( parseFloat( this.text ) ) ) {
				this.text = this.widget.text
				}
			/*else {
				if ( parseFloat( this.text ) > this.widget.maxValue ) {
					this.text = this.widget.maxValue;
					}
				if ( parseFloat( this.text ) < this.widget.minValue ) {
					this.text = this.widget.minValue;
					}
				this.text = this.text;
				this.slider.value = this.text;
				this.widget.text = this.text;
				}*/
			}
		else if ( this.length == 0 ) {
			this.text = this.widget.minValue;
			this.widget.text = this.text;
			}
		else if ( this.length > this.widget.maxValue ) {
			this.text = this.widget.maxValue;
			this.widget.text = this.text;
			}
		}
	editBox.onChange = function() {
		if ( isNaN( parseFloat( this.text ) ) ) {
			this.text = this.widget.text
			this.slider.value = this.widget.text;
			}
		else {
			if ( parseFloat( this.text ) > this.widget.maxValue ) {
				this.text = this.widget.maxValue;
				}
			if ( parseFloat( this.text ) < this.widget.minValue ) {
				this.text = this.widget.minValue;
				}
			this.text = this.text;
			this.widget.text = this.text;
			}	
		}
	}


	
HarbsUI.SliderBox = function( container, width, initialValue, minValue, maxValue ) {
	this.width = width || 50;
	this.initialValue = initialValue || 0;
	this.minValue = minValue || 0;
	this.maxValue = maxValue || 100;
	this.text = this.initialValue;

	var g = container.add( "group" );
	g.orientation = "column";
	g.spacing = 2;
	var editBox = g.add( "edittext", undefined, this.initialValue );
	editBox.preferredSize.width = width;
	editBox.slider = g.add( "slider", undefined, this.initialValue, this.minValue, this.maxValue );
	editBox.slider.preferredSize.width = width;
	editBox.slider.editBox = editBox;
	editBox.widget = this;
	editBox.onChanging = function() {
		if ( this.text.length > 1 ) {
			if ( isNaN( parseFloat( this.text ) ) ) {
				this.text = this.widget.text
				this.slider.value = this.widget.text;
			} /*else {
				if ( parseFloat( this.text ) > this.widget.maxValue ) {
					this.text = this.widget.maxValue;
				}
				if ( parseFloat( this.text ) < this.widget.minValue ) {
					this.text = this.widget.minValue;
				}
				this.text = this.text;
				this.slider.value = this.text;
				this.widget.text = this.text;
			}*/
		} else if ( this.length == 0 ) {
			this.text = this.widget.minValue;
			this.slider.value = this.text;
			this.widget.text = this.text;
		}
	}
	editBox.onChange = function() {
		if ( isNaN( parseFloat( this.text ) ) ) {
			this.text = this.widget.text
			this.slider.value = this.widget.text;
		} else {
			if ( parseFloat( this.text ) > this.widget.maxValue ) {
				this.text = this.widget.maxValue;
			}
			if ( parseFloat( this.text ) < this.widget.minValue ) {
				this.text = this.widget.minValue;
			}
			this.text = this.text;
			this.slider.value = this.text;
			this.widget.text = this.text;
		}	
	}
	editBox.slider.onChanging = function() {
		this.editBox.text = this.value;
		this.editBox.widget.text = this.value;
	}
}

//~ makeWindow = function() {
//~ 	var w = new Window( "palette", "Testing" );
//~ 	w.preferredSize.width=200;
//~ 	w.sliderBox = new HarbsUI.SliderBox( w, 100, 20, -1, 100 );
//~ 	w.DD = w.add("dropdownlist",undefined,"test",{items:["qwert yuiopl kjhggfds aazx cvbb t yuiopl kjhggfds aazx cvbb t yuiopl kjhggfds aazx cvbbnm","test2"]});
//~ //	var DD = w.add("dropdownlist",undefined,"test",{items:["qwert yuiopl kjhggfds aazx cvbb t yuiopl kjhggfds aazx cvbb t yuiopl kjhggfds aazx cvbbnm","test2"]});
//~ 	w.DD.preferredSize.width=250;
//~ 	w.DD.selection=0;
//~ 	w.show();
//~ 	
//~ 	w.onClose = function() {
//~ 		alert( "and the final value was: " + w.sliderBox.text );
//~ 	}
//~ }

//makeWindow();

HarbsUI.TextComboBox = function(container,listItems,selection,width,indent){
	var fld;
	container = container.add('group');
	this.width = width || 100;
	this.selection = selection || 0;
	this.listItems = listItems || [];
	this.text = this.listItems[this.selection] || '';
	this.indent = indent || 0;
	container.indent = this.indent;
	container.orientation = 'stack';
	container.alignChildren = 'left';
	if(app.locale==Locale.HEBREW_LOCALE){fld = container.add("edittext");}
	var dd = container.add("dropdownlist",undefined,undefined,{items:this.listItems});
	dd.selection=this.selection;
	dd.preferredSize.width = this.width;
	if(fld==undefined){fld = container.add("edittext");}
	fld.text =this.text;
	fld.preferredSize.width = this.width-20;
	dd.onChange = function(){
		fld.text = dd.selection.text;
		}
	return fld;
	}
//test = new Window ("dialog", "test");
//cmbx = new HarbsUI.TextComboEditBox(test,[1,3,5,7],0,70,0,);
//test.show()

HarbsUI.listboxClick = function (item){
	var onDoubleClick = function (item){
		if(item.detail ==2){
			if(that.hasOwnProperty("doubleClick")){
				that.doubleClick();
				}
			else if (that.hasOwnProperty("editButton")){
				that.editButton.notify("onClick");
				}
			}
		}
	if (this.hasOwnProperty("editButton")){
		if(this.selection){this.editButton.enabled = true;}
		else{this.editButton.enabled = false;}
		}
	if (this.hasOwnProperty("deleteButton")){
		if(this.selection){this.deleteButton.enabled = true;}
		else{this.deleteButton.enabled = false;}
		}
	//if(this.hasOwnProperty("customClick")){//added may 11 08
		//this.customClick();
		//~}
	var that = this;
	this.addEventListener('click', onDoubleClick);
	}
//EXAMPLE OF USE:
/*
test = new Window ("dialog", "List Box Click");
listbox = test.add('listbox',undefined,undefined,{items:[1,2,3]})
var editButton = test.add('button');
editButton.text = "Edit";
editButton.enabled=false;
listbox.editButton = editButton;
editButton.onClick = function (){
	alert("super!");
	}
listbox.onClick = HarbsUI.listboxClick;

//to use a unique double click function instead -- define one as below:
listbox.doubleClick = function(){
	alert("great!");
	}
test.show();
*/
HarbsUI.StandardButtonGroup = function (container,okayButton,cancelButton,spacer,newButton,editButton,deleteButton,size,orientation,alignChildren){
	if(!container){alert("You Must Provide a Container for the Button Group!");return;}
	//if(!alignChildren){alignChildren='fill';}
	//if(!orientation){orientation='column'}
	var group = container.add('group');
	group.orientation = orientation || 'column';
	group.alignChildren = alignChildren || 'fill';
	group.spacing = 0;
	if(size){
		if(group.orientation=='column'){
			group.preferredSize.width = size;
			}
		else if(group.orientation=='row'){
			group.preferredSize.height = size;
			}
		}
	if(okayButton || (okayButton == undefined && group.window.type == 'dialog')){
		if(!okayButton){okayButton="OK"}
		group.okayButton = group.add('button', undefined, okayButton, {name:'ok'});
		}
	if(cancelButton|| (cancelButton == undefined && group.window.type == 'dialog')){
		if(!cancelButton){cancelButton='Cancel'}
		group.cancelButton =group.add('button', undefined, cancelButton, {name:'cancel'});
		}
	group.cancelButton.onClick = function(){
		group.window.close();
		}
	if(spacer){
		group.spacer = group.add('group');
		if(group.orientation=='row'){
			group.spacer.preferredSize.width=spacer;
			}
		else{
			group.spacer.preferredSize.height=spacer;
			}
		}
	if(newButton){
		group.newButton =group.add('button', undefined, newButton);
		}
	if(editButton){
		group.editButton =group.add('button', undefined, editButton);
		}
	if(deleteButton){
		group.deleteButton =group.add('button', undefined, deleteButton);
		}
	return group;
	}
//
HarbsUI.DropDownDialog = function (title,dropdownLabel,dropdownList,selectedIndex){
	var w = new Window ('dialog', title);
	w.orientation = 'row';w.alignChildren = 'top';
	w.dropdown = new HarbsUI.DropdownGroup(w,dropdownLabel,dropdownList,selectedIndex);
	w.buttons = new HarbsUI.StandardButtonGroup(w);
	w.buttons.cancelButton.active = true;
	return w;
	}
//EXAMPLE USAGE:
//~ w=new HarbsUI.DropDownDialog("My Drop Down",'my fabulous items',[1023496738,'test',3,4,5]);
//~ if(w.show()){
//~ 	alert("fabulous");
//~ 	}
HarbsUI.DropdownGroup = function(container,dropdownLabel,dropdownList,selectedIndex,labelWidth,ddWidth,height){
	var group = container.add('group');
	group.orientation = 'row';
	group.alignChildren = 'top';
	if(height){group.maximumSize.height = height}
	group.group = group.add('group');
	group.group.orientation = 'column';
	group.group.alignChildren = 'right';
	group.group.margins = 0;
	if(labelWidth){group.group.preferredSize.width = labelWidth}
	group.label = group.group.add('statictext',undefined,dropdownLabel);
	group.dropdown = group.add('dropdownlist',undefined,undefined,{items:dropdownList});
	group.dropdown.selection = selectedIndex;
	if(ddWidth){group.dropdown.preferredSize.width = ddWidth;}
	group.dropdown.name = group.label;
	return group.dropdown;
	}
HarbsUI.TextEditGroup = function(container,fieldLabel,contents,labelWidth,fieldWidth,height,alternateLabel){
	var group = container.add('group');
	group.orientation = 'row';
	group.alignChildren = 'top';
	if(height){group.maximumSize.height = height}
	group.group = group.add('group');
	group.group.orientation = 'stack';
	group.group.alignChildren = 'right';
	group.group.margins = 0;
	if(labelWidth){group.group.preferredSize.width = labelWidth}
	group.label = group.group.add('statictext',undefined,fieldLabel);
	if(alternateLabel){
		group.alternateLabel=group.group.add('statictext',undefined,alternateLabel);
		}
	group.textEditBox = group.add('edittext',undefined,contents);
	if(fieldWidth){group.textEditBox.preferredSize.width = fieldWidth;}
	group.textEditBox.name = group.label;
	if(alternateLabel){group.textEditBox.alternateName = group.alternateLabel}
	return group.textEditBox;
	}
//EXAMPLES:
//~ w=new Window('dialog',"Test");
//~ w.orientation = 'row';w.alignChildren = 'top';
//~ w.g1 = w.add('group');
//~ w.g1.orientation='column';
//~ w.g1.spacing = 0;
//~ w.dd1 = new HarbsUI.DropdownGroup(w.g1,'drop down 1',[1,2,3],undefined,undefined,100,24);
//~ w.dd2 = new HarbsUI.DropdownGroup(w.g1,'drop down 2',[4,5,6],undefined,undefined,100,24);
//~ w.buttons = new HarbsUI.StandardButtonGroup(w);
/*//FOR MORE BUTTONS:
w.buttons = new HarbsUI.StandardButtonGroup(w,'OK','Cancel',15,"New","Edit","Delete");
//--OR--
//w.buttons = new HarbsUI.StandardButtonGroup(w,'Great','No Thanks',15,"New","Edit","Delete",40,'column','fill');
w.buttons.editButton.onClick = function(){alert('edit')}
w.buttons.newButton.onClick = function(){alert('new')}
w.buttons.deleteButton.onClick = function(){alert('delete')}
//*/
//w.buttons = new HarbsUI.EditButtonGroup(w,"OK","Cancel",10,"New","Edit","Delete",50,'row','fill');
//------They can be changed afterwards too...
//w.buttons.orientation='column';
//w.buttons.newButton.text = 'Fresh';
//~ if(w.show()){
//~ 	alert("fabulous");
//~ 	}
HarbsUI.StandardListBox = function(title,listBoxHeader,list,preferredSize,listInfo,language){
	language = language || 'English';
	var okName, newName, cancelName, editName, deleteName;
	if(language == 'English'){
		okName ="OK"; cancelName="Cancel"; newName="New"; editName = "Edit", deleteName="Delete";
		}
	var d = new Window ('dialog', title);
	d.orientation='row';
	d.alignChildren='top';
	preferredSize = preferredSize || [220,150];
	var font = d.graphics.font.family;
	var fontSize = d.graphics.font.size;
	d.column1 = d.add('group');
	d.column1.orientation='column';
	d.column1.alignChildren='left';
	//d.column2 = d.add('group');
	//d.column2.orientation='column';
	var text = d.column1.add("statictext",undefined,listBoxHeader);
	text.graphics.font = ScriptUI.newFont (font,'BOLD',fontSize);
	//text.alignment='left';
	var listBox = d.column1.add('listbox', undefined, undefined,{items:list});
	listBox.preferredSize = preferredSize;
	listBox.alignment = 'left';
	listBox.listInfo = listInfo;
	if(listBox.items.length>0){
		listBox.selection = listBox.items[0];
		}
	if(listInfo){
		var infoTitle = d.column1.add('statictext',undefined,'Info:');
		
		listBox.infoText = d.column1.add('statictext',undefined,listInfo[0],{multiline:true,scrolling:true});
		listBox.infoText.preferredSize.height = 90;
		listBox.infoText.preferredSize.width = 220;
		}
	listBox.onClick = HarbsUI.listboxClick;
	listBox.onChange = function(){
		var listBox = this;
		if(listBox.hasOwnProperty("infoText")){
			listBox.customClick();
			}
		if(listBox.selection){
			listBox.editButton.enabled=true;
			listBox.deleteButton.enabled=true;
			}
		else{
			listBox.editButton.enabled=false;
			listBox.deleteButton.enabled=false;
			}
		}
		
	listBox.customClick = function(){
		if(! listInfo){return}
		if(listBox.selection){
			var theIndex = listBox.selection.index;
			listBox.infoText.text = listBox.listInfo[theIndex];
			}
		else{listBox.infoText.text = "";}
		}
		

//d.listBox = d.column1.add('listbox');
//okName, newName, cancelName, editName, deleteName
	var buttonGroup = new HarbsUI.StandardButtonGroup(d,okName,cancelName,10,newName,editName,deleteName);
	listBox.newButton = buttonGroup.newButton;
	listBox.editButton = buttonGroup.editButton;
	listBox.deleteButton = buttonGroup.deleteButton;
	listBox.dialog = d;
	listBox.active=true;
	return listBox;
	}
//
/*
var listInfo = [
'One is a very interesting Number\nIt is the first One\nOne is Hashem!\n\n\nmore text',
'Two is also interesting\nTwo is "luchos Habris"',
"Three -- I'm getting bored"
]
var listBox = new HarbsUI.StandardListBox ('test','List',['one','two','three'],undefined,listInfo);
listBox.editButton.onClick = function(){
	alert('Edit!');
	}
listBox.newButton.onClick = function(){
	alert('New');
	}
listBox.deleteButton.onClick = function(){
	alert('Delete');
	}
if(listBox.dialog.show()){alert('good!')}
else{alert('no good!')}*/