/*********************************************************************************
    RedoHistory for InDesign CS3. Adapted from script written by Matevz Bradac (matevzb@email.si),
    this source is free for any (ab)use.
    adapted by Harbs
    This script displays a simple dialog with redo history in a dropdown control.
    It is a bit like the History plugin, but not as fancy (but then again, not as
    commercial either).
    When OK is clicked, all the actions from the last to the selected one are redone.
    Original was Undo history.
 *********************************************************************************/
(function() {
#include HarbsUI.jsx
var kAppVersion = parseFloat(app.version);
var i;
var document;
var myRedoHistory = new Array;
var historySize;
var dlg, column, row, dropdown;
if (app.documents.length == 0){alert ("No open documents.", "Redo history");exit ()}
document = app.activeDocument;
if (!document.redoHistory || document.redoHistory.length == 0)
{alert ("No redo history.", "Redo history");exit ()}
if(document.redoHistory.length>50){
	historySize = 50;
	}else{
	historySize = document.redoHistory.length;
	}
reverseRedoHistory = new Array (historySize);
for (i=historySize-1; i >= 0; i--){
	myRedoHistory[i] = document.redoHistory[i];
	}
// create the dialog
if(kAppVersion>=5){
	var dlg = new HarbsUI.DropDownDialog('Redo History',undefined,myRedoHistory,0);
	dlg.dropdown.active = true;
	}
else{
	dlg = app.dialogs.add ({name:"Redo history", canCancel:true});
	column = dlg.dialogColumns.add ();
	row = column.dialogRows.add ();
	dropdown = row.dropdowns.add ({stringList:myRedoHistory, selectedIndex:0});
	}
if (dlg.show ()){
	// user clicked OK -> undo up to the selected undo state
	if(kAppVersion<5){
		var numRedos = dropdown.selectedIndex;
		}
	else{
		var numRedos = dlg.dropdown.selection.index;
		}
	for (i=0; i < numRedos+1; i++){
		document.redo ();
		}
	}
if(kAppVersion<5){dlg.destroy ();}
} )();