﻿// SetVisualCharSize.jsx
// © cuppascript, 10/2009
//Description:Gib Zeichenhöhe ein statt Kegelhöhe
// Zur Verwendung mit markiertem Text oder Textrahmen 
// Es wird ein Buchstabe und eine Größe abgefragt. Der eingegebene Buchstabe wird vom Script testweise in Pfade umgewandelt, 
// um zu messen, wie das Verhältnis Kegel/Buchstabenhöhe ist. Damit weiß das Script, welcher Schriftgrad vonnöten ist, um 
// effektiv die gewünschte Zeichenhöhe zu erreichen.
// Gebrauch wie immer auf eigene Gefahr, 
// wir können nicht garantieren, dass das Script nicht mal unerwartete Ergebnisse erzeugt

// enable ExtendScript L10N automatism
$.localize = true;
// Localization-Objects
var sNoSelection = { en: "No text selected", de: "Es ist kein Text markiert." };
var sNoDocument = { en: "No document open", de: "Es ist kein Dokument offen." };
var sDialogName = { en: "Define character height", de: "Zeichenhöhe eingeben" };
var sCHeight = { en: "Height of Character:", de: "Höhe des Zeichens:" };
var sDefCharacter = { en: "Character:", de: "Maßgebendes Zeichen:" };

if (app.documents.length != 0){
	if (app.selection.length >0){
		var allSel = app.selection;
		var s = app.selection[0].constructor.name;
		switch (app.selection[0].constructor.name){
			case "Text":
			case "Character":
			case "Word":
			case "Line":
			case "TextStyleRange":
			case "TextColumn":
			case "Paragraph":
				main(false);
				break;
			case "TextFrame":
				var aSel = app.selection;
				var myHeight = false;
				for (var n = 0; n < aSel.length; n++) {
					if (aSel[n].constructor.name == "TextFrame") {
						if (aSel[n].parentStory.textContainers.length == 1) {
							app.select(aSel[n].texts);
							myHeight = main(myHeight);
						}
					}
				}
				break;
			default:
				alert(localize(sNoSelection));
				break;
		}
		app.select(allSel);
	}
	else{
		alert(localize(sNoSelection));
	}
}
else{
	alert(localize(sNoDocument));
}

function main(myHeight) {
	var prevHUnits = app.activeDocument.viewPreferences.horizontalMeasurementUnits;
	app.activeDocument.viewPreferences.horizontalMeasurementUnits = MeasurementUnits.millimeters;
	var prevVUnits = app.activeDocument.viewPreferences.verticalMeasurementUnits;
	app.activeDocument.viewPreferences.verticalMeasurementUnits = MeasurementUnits.millimeters;
	 
	var aStory = app.selection[0].parentStory;
	var tRanges = app.selection[0].textStyleRanges;
	var mySample = app.extractLabel("gs_versalhoehe");
	if (myHeight == false) {
		var aSize = app.selection[0].pointSize / getRel(aStory, app.selection[0].index, "H");
		var myDialog = app.dialogs.add({name:localize(sDialogName) });
		with(myDialog.dialogColumns.add()){
			with (dialogRows.add()) {
				staticTexts.add({minWidth: 180, staticLabel: localize(sCHeight) });
				var vHeightField = measurementEditboxes.add({editValue: (2.83465 * aSize), editUnits:MeasurementUnits.millimeters, smallNudge:0.5});
			}
			with (dialogRows.add()) {
				staticTexts.add({minWidth: 180, staticLabel: localize(sDefCharacter) });
				var mySampleField = textEditboxes.add({editContents: mySample});
			}
		}
		var myResult = myDialog.show();
		if(myResult == true){
			var vHeight = vHeightField.editValue * 0.35278;
			var mySample = mySampleField.editContents;
			if (mySample.length > 1) mySample = mySample.substr(0,1);
			app.insertLabel("gs_versalhoehe", mySample);
			myDialog.destroy();
		}
		else{
			var vHeight = false;
			myDialog.destroy();
		}
	} else {
		// Damit kann main() der gewünschte Wert übergeben werden und muss nicht mehr abgefragt werden.
		var vHeight = myHeight;
	}
	
	if (vHeight != false) {
		for (var n = 0; n < tRanges.length; n++) {
			var aRel = getRel(aStory, tRanges[n].index, mySample);
			tRanges[n].pointSize = vHeight * aRel;
		}
	}
	app.activeDocument.viewPreferences.horizontalMeasurementUnits = prevHUnits;
	app.activeDocument.viewPreferences.verticalMeasurementUnits = prevVUnits;	
	return vHeight;
}

function getRel(aStory, anIX, mySample) {
	aStory.characters[anIX].select();
	app.copy();
	var aPageWidth = app.activeDocument.documentPreferences.pageWidth;
	var aPageHeight = app.activeDocument.documentPreferences.pageHeight;
	var aFrame = app.layoutWindows[0].activePage.textFrames.add({geometricBounds: [0,0,aPageHeight, aPageWidth]});
	aFrame.insertionPoints[0].select();
	app.paste();

	var aChar = aFrame.characters[0];
	aChar.contents = mySample;
	var aSize = aChar.pointSize;
	var aPath = aChar.createOutlines();
	var bSize = aPath[0].geometricBounds[2]-aPath[0].geometricBounds[0];
	aFrame.remove();
	return aSize / bSize;
}