﻿/*  
XML Import Skript 
Version:     	1.0
License:	CC 
Last-Change:	9. November 2009

Autor + Copyright: Gregor Fellenz
http://www.indesignblog.com/
*/

#target InDesign 

xmlImport () ;

function xmlImport () {	
	
	// Check if any Document is open
	if (app.documents.length == 0 ) {
		alert ("Es muss mindestens ein Dokument geöffnet sein!", "Error")
		return;
	}

	// Load XML File 
	var _xmlFile = File.openDialog ("Bitte wählen Sie die zu verarbeitende XML Datei aus", "XML Dateien:*.xml" , false);
		if (_xmlFile == null) {
			alert ("Fehler bei Dateiauswahl!")
			return;
		}
	_dokument = app.activeDocument;
	
	with (_dokument.xmlImportPreferences) {
		allowTransform = false;
		createLinkToXML = false;
		ignoreUnmatchedIncoming = false;
		ignoreWhitespace = false; 
		importCALSTables = true;
		importStyle = XMLImportStyles.mergeImport;
		importTextIntoTables = false;
		importToSelected = false;
		removeUnmatchedExisting = false;
		repeatTextElements = true;
	}
		
	_dokument.importXML(_xmlFile);
	
    processLeerRaum(_dokument.xmlElements[0]); 
	
	// Get List of Block Level Elements from XML Tag Mapping and Process!!
	for (i = 0; i < _dokument.xmlImportMaps.length; i++) {
		if (_dokument.xmlImportMaps[i].mappedStyle.constructor.name == "ParagraphStyle" ) {					
			var _xpath = "//" + _dokument.xmlImportMaps[i].markupTag.name;
			var node  = null; 
			try { 
				var _proc  = app.xmlRuleProcessors.add([_xpath]); 
				var _match = _proc.startProcessingRuleSet(_dokument.xmlElements[0]); 
				while( _match!=undefined ) { 
					_node = _match.element; 
					_node.insertTextAsContent ("\r", XMLElementPosition.afterElement);
					_match = _proc.findNextMatch(); 
				}     
			}			
			catch( ex ) { 
				throw (ex); 
			} finally { 
				_proc.endProcessingRuleSet(); 
				_proc.remove(); 
			} 
		} //end if
	} // end for 	
    _dokument.mapXMLTagsToStyles ()

	// Object Styles 
	var _oStyle = _dokument.objectStyles.itemByName("info");
	var _xpath = "//info";
	var node  = null; 
	try { 
		var _proc  = app.xmlRuleProcessors.add([_xpath]); 
		var _match = _proc.startProcessingRuleSet(_dokument.xmlElements[0]); 
		while( _match!=undefined ) { 
			_node = _match.element; 
			_node.insertTextAsContent("\r", XMLElementPosition.afterElement);		
			var _atf = _node.placeIntoInlineFrame ([15,50]).getElements()[0];
			_atf.appliedObjectStyle = _oStyle;
			_atf.fit(FitOptions.frameToContent);
			_match = _proc.findNextMatch(); 
		}     
	}			
	catch( ex ) { 
		throw (ex); 
	} finally { 
		_proc.endProcessingRuleSet(); 
		_proc.remove(); 
	} 
}

	

function processLeerRaum(_dok) {
    app.findGrepPreferences = NothingEnum.NOTHING;
    app.changeGrepPreferences = NothingEnum.NOTHING;

	//~ 	// Tabulatoren raus 
	app.findGrepPreferences.findWhat = "\\t+\\r";
	app.changeGrepPreferences.changeTo = "\\r";
	_dok.changeGrep();

	app.findGrepPreferences.findWhat = "\\t+";
	app.changeGrepPreferences.changeTo = " ";
	_dok.changeGrep();

//~ 	// Leerräume raus 
	app.findGrepPreferences = NothingEnum.nothing;
	app.findGrepPreferences.findWhat = "\\s{2,}";
	var _results = _dok.findGrep (true);	


	for (var i = 0; i < _results.length ; i++) {
		var _res = _results[i];
		// Die Priorität der Zeichen entspricht der Reihenfolge im Array. Das letzte Zeichen ist das Wichtigste
		var _spaces = ["\u0020","\u00A0","\u202F","\u2008","\u2007","\u2001","\u200A","\u2009","\u2006","\u2005","\u2004","\u2002","\u2003","\t","\n","\r"];
		for (var k =0; k < _spaces.length; k++) {
			var _important = _res.contents.indexOf (_spaces[k]);
			if (_important > -1) _mostImportant = _important;
		}

		// Alle nicht benötigten Zeichen löschen. Erhalten bleiben bei der Suche ignnorierte Zeichen und das Zeichen das am Index des oben ermittelten wichtigsten Zeichen steht
		var _resChars = _res.characters.everyItem().getElements();
		for (var k = _resChars.length -1; k >= 0; k--) {
			var _char = _resChars[k];
			if ( _char.contents != "\uFEFF" && 
				_char.contents != SpecialCharacters.END_NESTED_STYLE &&
				_char.contents != SpecialCharacters.INDENT_HERE_TAB &&
				_char.contents != SpecialCharacters.DISCRETIONARY_HYPHEN &&
				_char.contents != SpecialCharacters.DISCRETIONARY_LINE_BREAK &&
				_char.contents != SpecialCharacters.ZERO_WIDTH_NONJOINER &&
				_char.contents != SpecialCharacters.ZERO_WIDTH_JOINER &&
				 k != _mostImportant) _char.remove ();
		}
	}

	app.findGrepPreferences.findWhat = "^\r";
	app.changeGrepPreferences.changeTo = "";
	_dok.changeGrep();
	
    app.findGrepPreferences = NothingEnum.NOTHING;
    app.changeGrepPreferences = NothingEnum.NOTHING;
}