﻿/*  
//DESCRIPTION: Das Skript exportiert jede Seite des Dokuments als PDF-Datei. Als Name wird die Eigenschaft label der Seite ausgelesen.
@Version: 1.0
@Date: 2011-03-01
@Author: Gregor Fellenz
http://www.publishingx.de

*/
#target InDesign

run ();

function run () {
	try {		
		// Prüfung ob gearbeitet werden kann
		if (app.documents.length == 0) {
			alert ("Kein Dokument geöffnet!");
			return;
		}

		var dok = app.activeDocument;
		if (!dok.saved) {
			var res = confirm ("Dokument ist nicht gespeichert. Jetzt speichern?");
			if (res) {
				dok.save();
			}
			else {
				return;
			}
		}
	

		var _userLevel = app.scriptPreferences.userInteractionLevel;
		app.scriptPreferences.userInteractionLevel = UserInteractionLevels.NEVER_INTERACT; 

		
		// doucment export 
		var _preset = getTypeGui();
		if (_preset == null) return;
		app.pdfExportPreferences.useDocumentBleedWithPDF = true;
		app.pdfExportPreferences.viewPDF = false;
		app.pdfExportPreferences.viewPDF = false;


		for (var i = 0; i < dok.pages.length; i++) {
			var _page = dok.pages[i];
			var _pageName = _page.label;
			if (_pageName == "") _pageName = _page.name;
			var _fileName = dok.fullName.toString().replace(".indd", "") + "_" +  _pageName + ".pdf";
			var _file = File (_fileName);
			app.pdfExportPreferences.pageRange = _page.name;
			dok.exportFile (ExportFormat.PDF_TYPE, _file, false, _preset );
		}
	} catch (e) {
		_desc = e.msg;
		_line = e.line;
		_num = e.number;
		alert("Fehler [" + _num + "] " + _desc + " Line: " + _line);
	}
	finally {
		app.scriptPreferences.userInteractionLevel = _userLevel;
	}
}

function getTypeGui() {
	
	
	var typArray = [];
	for (var i = 0; i < app.pdfExportPresets.length; i++) {
		typArray.push(app.pdfExportPresets[i].name);
	}
	
	
	var win = new Window("dialog", 'PDF Preset auswählen ', [0,0,260,59]);
	with(win){
		ddList = add( "dropdownlist", [5,5,255,27], typArray, {name: 'typ', } );
		ddList.selection = 0;
		ddList.active = true;
		butCancel = add( "button", [60,32,155,54], 'Abbrechen', {name: 'cancel' });
		butOk = add( "button", [160,32,255,54], 'Preset wählen',  {name: 'ok' } );
	}

	win.center();
	var result = win.show();
	if (result == 2) return null;
	return app.pdfExportPresets.itemByName(ddList.selection.text);	
}
	