﻿#target InDesign;
#targetengine "sessionGrep";
//DESCRIPTION: GREP Fundstellen hervorheben 

/*     
    + Indesign Version: 8.0
    + Autor: Roland Dreger
    + Datum: 8. Juni 2013
    
    
    + Hinweis: Im Zuge der Programmausfuehrung wird eine Bedingung (fuer "Bedingter Text") 
      mit dem Namen "::Highlight_GREP::" erzeugt. Diese Bedingung wird nach Beenden des Skripts wieder entfernt. 
    
      Tritt ein Programmfehler auf, bleibt die Bedingung möglicherweise bestehen und muss (wenn gewuenscht)
      manuell geloescht werden.
    
      Wichtig: 
      Wenn im durchsuchten Dokument bereits andere Bedingung (fuer "Bedingter Text") vorhanden sind,
      koennen diese in einigen Faellen durch die Suche ueberschrieben werden.
      
      
    + Thanks to Peter Kahrel (www.kahrel.plus.com) for his idea to use conditional text for highlighting. 
*/


// Globals 
var _highlightColor = [255,150,0]; // Farbe der Hervorhebung in [R,G,B] (die Farbe kann auch einfach im Bedinfeld fuer "Bedingter Text" geaendert werden)
var _highlightMethod = ConditionIndicatorMethod.USE_HIGHLIGHT; // "USE_UNDERLINE" fuer Hervorhebung durch Unterstreichung

var _alertCounter = false; // Warnmeldung bedingter Text
if (app.documents.length > 0) {
    var _currentDoc = app.activeDocument.getElements()[0]; // Warnmeldung bedingter Text
}
var _lastDoc = _currentDoc; // Warnmeldung bedingter Text

if (app.documents.length > 0) { 	
  app.doScript(main, ScriptLanguage.JAVASCRIPT , [], UndoModes.ENTIRE_SCRIPT, "Highlight GREP");  
} else {
	alert ("Kein Dokument geöffnet!");
}


function main () {
  
  app.scriptPreferences.enableRedraw = true;
  prototypeItemByLabel ();
  var _ui = _highlightPalette ();
  
  _ui.show(); 
}


function _highlightPalette () {
  
  var _doc = app.activeDocument;
  var _hits = 0; // Anzahl der Treffer
  var _sc = 0; // Zaehler fuer Auswahl
  var _filePath = filePath ();
  var _palette = Window.find("palette", "Highlight GREP Results", undefined, {borderless: false, closeButton: true}); /* refresh UI */
   
  if (_palette==null) {  /* refresh UI */   
    _palette = new Window ("palette", "Highlight GREP Results");
    with (_palette) {     
      orientation = "row";
      margins = 10;
      spacing = 0;
      var _columnLeft = add ("group");
      with (_columnLeft) {
        orientation = "column";
        alignment = ["", "fill"];
        alignChildren = ["left","fill"];
        margins = [3,25,0,16];
        var _hitsGroup = add ("group");
        with (_hitsGroup) {
          orientation = "column";
          alignChildren = "left";
          spacing = 0;
          margins.right = 0;
          var _numberOfHits = add ("statictext", undefined, "0");
          with (_numberOfHits) {
            characters = 6;
            graphics.font = "dialog:32";
            graphics.foregroundColor = graphics.newPen (graphics.PenType.SOLID_COLOR, [0.2, 0.2, 0.2], 1);
            helpTip = "Anzahl der Fundstelle(n)";
          } // END statictext _numberOfHits         
          var _hitsButtonGroup = add ("group");
          with (_hitsButtonGroup) {
            margins.top = 10;
            spacing = 0;
            margins.left = -4;
            try {
              var _selectionButtonIcon = "\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x14\x00\x00\x00\x1C\b\x06\x00\x00\x00a\u00DA\u009F`\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\u00C9e<\x00\x00\x01\u009AIDATx\u00DAb\u00FC\u00FF\u00FF?\x035\x01\x13\x03\u0095\x01\u00D5\rdtppH\x02\u00D2\u0093\u0080\u0098\u009BH=\u00A00\u00BA\x04\u00C4\x13\u0080x\u00E1\u00FE\u00FD\u00FB\u00FF\u00A3\x1B\u00F8\x11j\u00D8U\u00A8bB@\x01\u0088\u00F9\u00A1\u00ECy@\u009C\u0082l(\x0B\x10\u00F3\x01\u00F1!\u00A0\u00A0=1\u00CEstt\x04\u00B9,\x1F\u0088O\x031\u00C8w_\u00A0|\u00940$'\u00AA\u00BD\u0081\u00F8:\x10\u00E7\x01-\u00A9\u00A78R\u0080>z\r\u00A4\u00DC\u0080\u00F8!\x107\x00\r\u00CD\u00A58\u0096\u0081\u0086>\x01R.@\u00FC\n\x14I@CMX\u00C85\f\x1A\u00960p\tjp%\x0B\u009A\">\u00A8$:\u00D8\x05tM\x1A\u009AX>\x16u\u00AE,X\x12\u00BA<\x16\u0085bH\u00ECJP\u0098aQ\u00B3\x05\u0088\u00AD\u00D1\r\u00FC\r\u00C4\x1B\u00B1(>\u0089\x14n\u00DF\u0081\u00D4w,A\u00F0\x07\u0096\x0E\u0091\x03\u00F9+\u0090\n\u00A0$\u00A2X\u0088\b|I e\u008EC\u00FA!\u00D0\x11\u00E7I2\x10j\u00D8z,\u00E2O\u0081\u00D8\u0092Z\u00A5\u00CD\x1B v\x06\u00BA\u00EE1\u00B5\f\u009C\x014\u00EC&5\u00CB\u00C3*`\u00D8\u0086Rj (I]C\u00D2\u00B7\x14h\u00A8\x1B\u00B9\x06\u0082J\u00A3D v\u0080\u0096\u009B \u00C0\n\u00C4\x1B\u0080\u0086Z\u0092c`\x0E0\u00CC\u0096BK\x18\x0F \u00BE\x0F\x15\u00E7\x04\u00E2\u00ED@CuI1p'\u00D0\u00A0ih%\f\u00C8\u00AB/\u00A0B\u00A0\u00D2\u00DB\u0082h\x03\u00A1Y\r]\u00EC\x0E\u00D4PP\u00F5Q\x07\u00E4\u00CF\u00A6F\x01{\x19H\u00E9\x01\u00E9fla\u00C8H\u00A6\u00A1\u008F\u0090+<rk=\u00AC\u00D51\x10k\x03\u00F17P^.\u0084\u00D6\u00CBz\x14\u00D6\u00F1\u00A0\u0092\u00AA\x00 \u00C0\x00ml\u0086\x02\u00A8\u00E9/\u00E8\x00\x00\x00\x00IEND\u00AEB`\u0082";
              var _selectionButton = add ("iconbutton", undefined, _selectionButtonIcon, {style: "toolbutton"});
              with (_selectionButton) {
                helpTip = "Auswahl der Fundstelle(n)";
              } // END iconbutton _selectionButtonIcon
            } catch (e) {
              var _selectionButton = add ("button", undefined, "A");
              with (_selectionButton) {
                preferredSize.height = 23;
                preferredSize.width = 23;
                graphics.font = "dialog:11";
                helpTip = "Auswahl der Fundstelle(n)";
              } // END button _selectionButton
            } // END selection icon                        
            try {
              var _copyButtonIcon = "\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x15\x00\x00\x00\x1C\b\x06\x00\x00\x00\u008E\x18\u00F4^\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\u00C9e<\x00\x00\x01\u00C2IDATx\u00DA\u00BC\u00961K\u00C3@\x14\u00C7\u00AF\u00A1C[\x14\u00FB\x05\u008A\u008A[A\u00A9\u008Bk\u00D3\u00A5\u009B_\u00C0\u00C5\u00DDE*\x0E.\u00A2\u00D6A\x07\u00C1\u00E2\u00D2\u00D6\u00A1\u00E2'\x107\u00A7VGAj@\u0084.R\x15\x0B\u00ADHP!\x18A\u0089\u00FF+w\u00E1\f9\u00F5\u00DA\u00D4\x07?\u00DE\u00DD\u00E5\u00DD?\u0097\u00F7^\u009A\u0086\x1C\u00C7!2\u00CBd2\u00CBp\u009B \",\u00DB`\u00B5V\u00AB\u00ED\u00C8\u00F6\u0085~\x11}\u008BE\u00A3\u0091D\"\u00E1\u00AE=\u00B4Z\u00C4\u00B2,*<\f\u00E1\x0F\u00BF}a\u00F2\u00B3u\x05K\u00E5\u00B2\u00BB\u00B0\u0094\u00CB\u0091K\u00C3\u00A0'\x1F\x02\u00CF\u00BE\u00A28\u00CD<\u00FC8h\u00806\u00D0\u00C5\x00\u00D34\u00C9a\u00E5\u00C0\u009Dw:\u008F|\u00B8\u0082\u00BD6\x1B\u009F\u00828H\u0081fH\u00D7u\u00FE\u00FC\u00C7\u00C0\x00kD\u00DD6\u00C0\x18\u00A0\x07$\x1A[\u00BC\x05[\u00A4?\u00DB\x03\u00D7\u00A2\u00E8\x0B\u0092~\u00DE\u008F\"\u00F6\u00D7\u00E1\u009E\u00FC\n\u00B5\r\n=h\u00DA\u00D2\u00EA\u00E3n\u00B67\u00A0\x17\x0B{\u00FAr\x02n\u00D2\x13\u00D3\u00C0\u00CD\x1A\u00B8\u0096\u00C58F\u00EF\u00CD\u00C3\u0085\u0098+\u00C4\u00DC\u00C8\u00FAt\x16\u00EC\u00FATv\x1D\u00EC\u0083Q0\u00CD\u00D6\u008F\u0084\u0098\u009C\u00986\u00AF\u00E8;-\u009A$_\u00AF\u00EC\u00DA'/\u00AEg\u009F4\u00A7E\u00B8\u00A2\u00A4\u00BAS\u009E\u00A5\u00F8_s\u009A\u0084\u009B\x01\u00F7\x10\u00A9bN\u00C7I!\u00A4\u008D\u00F5\x13\u00A5B\u00C1\u00B2,\u00A7\u00F4\u00ED\u00AA\u00829\u00B0(\\?\x03\u00CA\u00A24ow\u0080\u00BF\u00E0&\u009B\u00BB'Un)<Z\x05\u00AE\"\u00CC\u00F3py\u00D5>\u00D5\u00C8\x00l \u00A2a\u00D5\r\u00E8\u0088\x02\u00FB\u00DD\u00F4\u00B3TO\u00A2lc\u00FA\u00BF\x1F\u00BF\x14\u00B4h\t,hA\x0B\u00A2\r\x1D-h\u00C1\u00A0r\u00FAM\u00B0\u00FBg\u0082}M-p\u00A1P\u00FD\x11\u0099 o\u00A9&\u00FB\u00EE\u00A7\u00FB=!\u00B7/\x01\x06\x00\x0E\n\u0099[\u00B6\u00EF=9\x00\x00\x00\x00IEND\u00AEB`\u0082";
              var _copyButton = add ("iconbutton", undefined, _copyButtonIcon, {style: "toolbutton"});
              with (_copyButton) {
                helpTip = "Fundstelle(n) in die Zwischenablage kopieren";
              } // END iconbutton _copyButton
            } catch (e) {           
              var _copyButton = add ("button", undefined, "K");
              with (_copyButton) {
                preferredSize.height = 23;
                preferredSize.width = 23;
                graphics.font = "dialog:11";
                helpTip = "Fundstellen in die Zwischenablage kopieren";
              } // END button _copyButton  
            } // END copy icon          
            try {
              var _clearConditionButtonIcon = "\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x15\x00\x00\x00\x1C\b\x06\x00\x00\x00\u008E\x18\u00F4^\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\u00C9e<\x00\x00\x02_IDATx\u00DA\u00EC\u0096Oh\x13A\x14\u00C6w\u00AA\u0081z\u00F1\u00A4\u0087\u0082\x17\u00C5[\u0089E\u00B4\bz\u00E8F\u00A1\x12(\x1ED\x14\u008D\u0088-\"6\u00C1\u009B\x7Fj\x15\u009B\\\u009Az\u00EDA/\x11QT\x04ED\u00A4J+l<\b\"\u0094\u0092\u00E6\u00D0^\x14\u00F5\x12O\u0082\x15#1\u0094\u00F8{a6\f\u00DB\u009DM\x0F\u00ED\u00CD\u0081\u008Fo\u00D8y\u00F3\u00ED7o\u00DE\u00CC\u00AEj4\x1A\u00CEZ\u00B7\x0Eg\x1D\u00DA\x7F\u00D1\u00B5o\u00AA\u00AF\u00CF\u00CD\u00C3\u00DF\u008AE\u00EF\u00CEj'%\x12\u0089\u00DD\u0090\u00C4\u00EF\x03\x15p\x17\u00E4=\u00CF\u00AB\u00FAN\x15\u00B8\u00ED\u00BA\u0089\u00E1U\n\x1E\u0080\u008AZPZ\x17\u00B8\x01\u00DE3\u00B6\u00B5\u00E9T\u00EA\x14\u00C1\t\u00FAWA:\u00CA1\u0093\x0EB\u00AF\u00C0&K\u00C8,\u00D8\u00DF\u00CC)B#\u00D0\u00AD(\u00C7\u0086\u00E0\x07 \u00FD\u00A5\u0090\u00B0=`\u00B8\u00B5QQ\u00C2\x01\u00C1\x01r\u00E7\u00C1\u00FD\x16\u00E1\u00E3*xL\u0083\u00A9@\u00B0\u0097\u00FE;\u00F0\x16\u009C@\u00EF\u008F\u00F12\u00C9\u00EB4\u00D8lH\u00CC\u00AB\u00B0\u00B3o\b_S\u00CA\u0099\u0084/\u00EB\u00DD\u00FD\x1B\u0092\x16Y\u00F2\x1B\u00B0E?\x1AW\u00B6\x0B\x05\u00E1'\u00E2L\u00D2\u0081\u00E3L\u009B\u008A8\x0B\u00DD\x03\u0092\u0096d\u00A8(AG\u00A0g\f}\u0085wFU\u0085\u0091\u0082\x05\u00D9@\u00A9\u00D5\x0E\u009B\u00A0,\u0089\u00A5wGU\u0085!\u00B8\b\x0E\u009B\u00C5\x1F*\b\u008EI\x0EmU\x11\x10\u00EC'\u00F6\u00E7\u008A\u00B3OP't\x1F\u00C4\u00C0/\u00B0l)\u00B7\u00B4~|1L\u00B0u\u00A2\u00B4h\nzh\u008C=\x06g\u0098\u00B0ll^\x0E\u00BA\t\u009E\u0093\u009A\u0093p'\u00E3KQ\u00B7\u00D4P`\u00EC\x14x\u00C0\u00CB6\u00B4\x1C(g\n\u00D4\u00E8\x1E\u00C5\u00CB\u00A50\u00C1\u0096S&\u00EE\u00A0\u00FF\u00C9R1M\u00C7`\u00AF\u009FC\u00A6\u00BC\u0086\u00C7\u00A4\u008EI\u00CD\u0084\u00CD\u00E9`D\x19\u008A\u00E3\u0097\u00E6\u00A6 \u0094\x15A9\x10\u00A4dd\u0085S\u00D7uey_\u00C0\u00B66\u00B7\u00DE\u00C7\u00E0\u00A6h\u00C1|\u00D0\u00B1\u0088&\u00E1\u00A9\b\u00B1\u009A.\u00B3L*\u0095\u00BA\x02\u008F\u009A\u0083\u00A5\u00D2\u00BCS.\u0097\u009DX,\u0096\u009B\u0099\u0099\u00CE\u00FA\u00CB?g\x11\u009B\u00D3e\u00D3\u0085\u00BB\u00D3\b\u009E\x0F\nJ\u00EB\u00E9\u00D9\u00E5\u00C4\u00E3q\u00A7^\u00AF\u008Fq\u0099\u008D\u00FAN?\u00C3\u00DBu\u00CC\x0F\u00F0H>\x0F\b\u0095\u00FC\u0089\u0085B\u00E1\u0082\u00FE|X\u009B\u00EFX)u}\u00A3\u00BE\x17%\x1FO\u00C1\x0B\u00C4jf0\u0082\u0092\u00EB^}0\u00ACM\x1CW\u00AB\u00BF\u00E3\u0095\u00CA\u00F7Cj=~{\u00FE\t0\x00\u00E2\u00B5\f\"\x0E\u00A3\u00CE\u00E2\x00\x00\x00\x00IEND\u00AEB`\u0082"; 
              var _clearConditionButton = add ("iconbutton", undefined, _clearConditionButtonIcon, {style: "toolbutton"});
              with (_clearConditionButton) {
                helpTip = "Highlight entfernen";
              } // END iconbutton _clearConditionButton
            } catch (e) {           
              var _clearConditionButton = add ("button", undefined, "X");
              with (_clearConditionButton) {
                preferredSize.height = 23;
                preferredSize.width = 23;
                graphics.font = "dialog:11";
                helpTip = "Highlight entfernen";
              } // END button _clearConditionButton
            } // END icon clear condition 
          } // END group _hitsButtonGroup
        } // END group _hitsGroup        
        var _liveModusGroup = add ("group");
        with (_liveModusGroup) {
          alignChildren = "bottom";
          var _live = add ("checkbox", undefined, "Live Modus");
          with (_live) {
            value = false;
            graphics.font = "dialog:11";
          } // END checkboxlive 
        } // END group _liveModusGroup
      } // END group _columnLeft    
      var _columnRight = add ("group");
      with (_columnRight) {
        orientation = "column";
        alignChildren = "fill";
        spacing = 15;
        var _findPanel = add ("panel", undefined, "");    
        with (_findPanel) {
          orientation = "row";
          alignChildren = "top";
          margins = [13,15,13,4];
          var _findPanelColumnLeft = add ("group");       
          with (_findPanelColumnLeft) {
            orientation = "column";
            spacing = 5;
            var _inputGroup = add ("group");
            with (_inputGroup) {
              spacing = 0;
              margins.right = 2;
              var _suchen = add ("statictext", undefined, "Suchen nach:");
              var _inputGrep = add ("edittext", undefined, "", {multiline: false});
              with (_inputGrep) {  
                active = true;
                characters = 42;
              } // END edittext _inputGrep                       
              // Icon Sonderezeichen fuer Suche einfuegen
              try {
                var _wildcardsFindIcon = "\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x14\x00\x00\x00\x14\b\x06\x00\x00\x00\u008D\u0089\x1D\r\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\u00C9e<\x00\x00\x03\\IDATx\u00DA\u0094UiO\x13Q\x14=\u00A5\u00D3\r\u00A1\u0094\u0096VP[\x04\u0095j\x14TD\u00A3\u00D6\u0095\u0080\x0B\u00AEiP\"FcL\u0094\x18\u00F5\u0093\x1F4\u00FE\x00\u00E3o\u00D0\u00F8A\u00A3\x01\u008DF\u00A3\u0082\x0BKb\x10\u00D0*\x10q\u00AB\u00D6\u00A5\u00A1 `J\u00B5S(\u00D3R\u00A8\u00F7\u008D:f,\u009Ap\u009B3\u00EF\u00F6\u00E6\u00DD3\u00E7\u00BDw\u00DF\x1DEee%\u00C8\u00E6\x10\u00CE\x12J\bzL\u00CExB\x03\u00E1\x14\u00C1\u00C3\u00D1\u00C3\u009E\u0092\u0092\u00EA..)E\u00E1\u0092\u00A5HNN\u009E\x14[8\x1C\u00D6w\u00B4?s65\u00D4;\u0087\u0086Bs\u0095\u00F9\u00F9\u00F9\u00E76n*\u009B\u00E7p\u00AC\x02\u00C7)\x11\u008F\u008FO\n,\u00C7j\u00B5\u0089\u00FE\x07\u008Fg\x1ASXb\u009F\u009F\u008Fa!\u00FAO\x15!\u009EG\u0090\x0FB\u00A3\u00D1\u00C0l\u00B6L8g\u00FE\u00C2B\u00DC\u00AB\u00AB\u00DD\u00C0\u0089{\u00A6PbD\u0088$L\u00EA\u00ED\u00ED\u00C1\u00C3\u00FBu\u00E8\u00F6z\u00A5X\u0086\u00D9\u008C\u00CD[\u00B7#7w\u0096|2q\u0090\u00A50B\u008C\u008E\u008E&\u0090\u00B9\u00DF\u00BE\u00C1\u00F5\u00AB\u00D5\u00B0eg\u00C3\u00B9\u00AB\x02z}\x1AxR\u00E9z\u00D2\u008A\u008B\x17\u00CEc\u00EF\u00FE\x03\u00C8\u00F9\u009B\u0094L$\u008C\u00C5\u00C6d\u00C1\u00A1P\bwo\u00DF\u00C2\u00EC<;\u00CAw\u00EF\u0091\u00E2\u0096\u00A9\u0099\u00F4\u0082\x1C\\\u00AD\u00BE\u008C{\u00B5wp\u00F8\u00C8\u00F1\x7F\x10\u008E\u00C9\t[Z\u009A1>\x1EG\u00D9\u00B6\u009D\x18\u00F8:\u0080\u00A7\u00AD-H3\x18 \b\x02\u00AC6\x1BV8V\u00A3\u00E6\u00CA%\u00F8|\u00DD\u00C8\u009A6=\u0091P\x18\x11d\u00C1\x17\u009D\x1DX\\X$\u00C6\u00D9\u00F2\u0098\u00E9\u00A8\u009C\x02~?,\u0096r\u00D8l9\x18\u00A3U}\u00FE\u00F4\x11\u00E9\u00E9\u00A6D\u00C2>\x7F@\n|\u00FF\x16\u0080?\x10\u0080jJ*\u00DA\\.\u00D1\u00DF\u00B9k\x0F\x06\u00FA\u00FB\u00E0\u00EB\u00E9A\u008C6\u009F\u00CD\x1F&\u00B5\u0083\u00C1\u0090,\u0097Y\x12{\u008CS\r\u00FDF$\x1AA\u009C~\u009CJE\n<\u00A2o\u00A2R\t\u00D1\u00810_OK\x0F\x04\x06E\u00DF\u0090n\u0094\u00E5J\n9N\u00F5G\u00B2\u0092C\u0092\"I\x1C\r\x06#|\u008A\u00CF\u00E8\u00EAx\u008EO\u009E\u00F7b\u00FC\u00DB\u00E0 \u009E<~\x04\u0093\u00C9\f\u00DB\u00CC\u00DC\u0084C\x11\x15j\u00D4\x1A\t3\u00AC\u00D9P*\u0095\u00E8\u00FF\u00D2\u0083\u00A5\u00CB\x1DTwS\u00E1\u00A5\u00BD*\u00DEP\x06\u00BA\u00A2\u00B8}\u00A3F,\u00B3-;\u00CAey\f\u0092B\u009DN-{K\u00C1\u00A2\u00C5x\u00FB\u00EA\x05\x16\x14\x14\u00E0`\u00D5\x11)>\u00C7\u009EG\n\u00FD\x18\x0E\u00F1\u0088E\u00C3\u0094\u00975\u00B1B\u009DV+\u00C3\u00AA5\u00EBh\x1B8\u00DC\u00BCV\u008D\u008F\u00EF\u00DD\b\u00D2\u00C1|\u00A5Cy\u00DD\u00D5\u0089\u00999\u00B9\u0088\u008DFQKJ]\u00CDMP\u00AB8)OR\u0098:%E\u00F6\x16\u00F6\u00FFP\u00D5Q45<@\u00E3\u0083\u00BA?\u00D7.\u00C3\x02\u00C7\u00CA5\u00D0\u008A\u00CB\u008B\u00A3\u00FDi+\u00A2\u0091\b\u009C\x15\u00FBde\u00C3'k\u00B5z\u00DD_m\u00CBd4\"\u008Fn\nO\u008D\u0081\x0F~\u00A7\u00C6\u00A0\u0085\u00D9\u00F2\u00B31\u00F8\u00BC\x1F\u00C4q\u00E5\u00EA\u00F5p\u00EE\u00DE\x0B\u00B5Z\u008D\u0091pX\u00BCd\u008C\u00B0\u00E1\u009D\u00FB\u00A5smq\u00E9\u0084]$\u00CD\u00C0\u00FA\u00ED\fY\u008C5\u0088\u00E3'N\u00A2h\u00D9\n)\u00F6\u00DC\u00F5\u0098\r\x0FY?\u00EC\u00EA\u00ED\u00F6\x1ES\u00AB\u0095\u00C8\u00CC\u00B2\u0090\x12*\u009B\u00A4\u00F8\x7Fa\u00CB\u00B6R5L\x17}A\x18F\x1B\u0095Q#u\u00A5h4\u00EAT\u00FC\u00FA\x04\u00D8\tg\bLf\u00EA$?\x01!B=\u00E14\u00E1\u00DD\x0F\x01\x06\x00\u00BEno\u00A9ry1O\x00\x00\x00\x00IEND\u00AEB`\u0082";
                var _wildcardsFind = add ("iconbutton", undefined, _wildcardsFindIcon, {style: "toolbutton"});
                with (_wildcardsFind) {
                  size = [22,22];
                  helpTip = "Sonderzeichen für Suche";
                } // END iconbutton _wildcardsFind
              }
              catch (e) { 
                var _wildcardsFind = add ("button", undefined, "@");
                with (_wildcardsFind) {
                  size = [22,23]
                  helpTip = "Sonderzeichen für Suche";
                } // END iconbutton _wildcardsFind
              } // END Icon Sonderezeichen einfuegen            
            } // END group _inputGroup 
            var _findFormatGroup = add ("group");
            with (_findFormatGroup) {
              alignment = "right";
              // Icon: Refresh FindStyles
              try {
                var _refreshFindStylesIcon = "\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x12\x00\x00\x00\x11\b\x06\x00\x00\x00\u00D0Z\u00FC\u00F9\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\u00C9e<\x00\x00\x01=IDATx\u00DA\u00AC\u00D4=H\x03A\x10\u0086\u00E1\u00BDD4*\bZ*A\u00B1\u00B3Ke%b\u00A1\u00A0\x07\x01[\u0083\u0085\u00B5\bi\u00D2\u00A4\u00B6\u00B1\x14\x05{\x0B\x7FJA\u00B4\u00B3\u00B2S\u008BtV!\u0085\u00C4RA\u0088\x1A\u0089\u009E\u00EF\u0084\x11\u0086e\u00AF\u00F2\x16\x1E\b\u00BB\u00CBw\u00B7;sqI\u0092\u00B8\u00FF\x0E\u00C9\x18HY\u009B@\u008CyL\"\u00876\u00EEq\u00817\u00DD\u00B7\u00813\u00F9\x11IZ\x14E6d\x01;\x18\u00C5'\u009Ed\x1F\u008A\x18B\x07\x07\u0098F\x05\u00E5~\u0086\x17\u00B4\u0088\x1A\u00DEq\u008C\x1B|\u00E9\u00DA \u0096\u00B1\u0085a\u00F3\u00E0\u00B2\x7F\u00B4qlkH\x1D-\u00EF\u00B8\x12x\u00ADo\x12\u00FBwa\u0083f\u00D1\u00C3I \u00C4\u0099;\u0089C\x0B\u00FE\u00D1$X\u00CA\u00F8\x1D\u00D8+\u00F73\x17\u0098o\u00F4+\u009FU\u00F9s.\u00A3a\u00EF\u00A8\x14X\x7FD70\u009F\u00D7\u0096\u00E8\u0085\u0082v\u00BD\u00CD\u00D2h\u008D\u0094\x17X\u00C1&\u00F6\u00F1\u00E0\x07\u00D9!e>MY\u009B\u00D1^\u0092\u00D1\u00FC\u009BL\u00BB\u00A3%\u00ACi\x13:\u00D3\u0090\u00AB\u00D8\u00C3\b\u008E\u00F0\x1A*\u00FF%\u00CE\u00B5\u0087\u00AA\u00BA\u00B9\u00AB\u009FH\u00A2\u009FH\x01\x1F8\u00C4\u00AD\u00AD\u009A\r\u00AA\u0098\u00E3\u008Ca]?\u00DA)\u00FC\u00E0\x19w\u00B8\u00C2\u008B_~\u0097\u00E9\u00DFH\x16a\u00BF\x02\f\x00\u00BD/g\u00CDu\u00B8\u009C'\x00\x00\x00\x00IEND\u00AEB`\u0082";
                var _refreshFindStyles = add ("iconbutton", undefined, _refreshFindStylesIcon, {style: "toolbutton"});
                with (_refreshFindStyles) {
                  size = [24,24];
                  helpTip = "Zeichen- und Absatzformate aktualisieren";
                }
              }
              catch (e) { 
                var _refreshFindStyles = add ("button", undefined, "R");
                with (_refreshFindStyles) {
                  size = [24,24];
                  graphics.font = "dialog:11";
                  helpTip = "Zeichen- und Absatzformate aktualisieren";
                } // END button _refreshFindStyles
              } // END Icon: Refresh FindStyles          
              var _findCharacterStyles = add ("dropdownlist", undefined, _doc.characterStyles.everyItem().name);
              with (_findCharacterStyles) {
                graphics.font = "dialog:11";
                graphics.foregroundColor = graphics.newPen (graphics.PenType.SOLID_COLOR, [0.13, 0.13, 0.13], 1);
              } //END dropdownlist _findCharacterStyles
              var _findParagraphStyles = add ("dropdownlist", undefined, _doc.paragraphStyles.everyItem().name);
              with (_findParagraphStyles) {
                graphics.font = "dialog:11";
                graphics.foregroundColor = graphics.newPen (graphics.PenType.SOLID_COLOR, [0.13, 0.13, 0.13], 1);
              } // END dropdownlist _findParagraphStyles
              writeStyleItems (_findCharacterStyles, _findParagraphStyles);        
            } // END group _findFormatGroup             
            var _placesGroup = add ("group");
            with (_placesGroup) {
              alignment = "right";
              margins.top = 16;
              // Icon: Ausgeblendete Ebenen und Objekte einschließen
              try {
                var _hiddenLayersIcon = "\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x12\x00\x00\x00\x11\b\x06\x00\x00\x00\u00D0Z\u00FC\u00F9\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\u00C9e<\x00\x00\x01|IDATx\u00DA\u00CC\u0092?\u008B\u00C2@\x10\u00C5\u00DF\x1EA\x14\x0B\x05+\x0F\x0B\u00DB+R\x04,\u00FC\u00C3\u0095)\u00AC\x04\u00C1F\u009B\u00D4~\x1C{A?A\u0084\x14\u008A\u008D\u008DXXYh\x17\x14\u009B\u00C3\u00D6B\x03\x11\u009D\u00CB\x06Wv\u00D5x\u008D\u00C5=\x18\u00B2\u009By\u00F3\u00DBdf\x19\x11\u00E1\x1D\u00FA\u00C0\u009B\u00F4\u00FF@\u00DA\u00AB\u00E4`0\u00A0\u00E5r\u0089\u00C3\u00E1\x00]\u00D7\u00D1l6Y\u0094\u0097=k\u00F6x<\u00A6\u00D5j\u0085\u00DDn\x17\u00EE\u00B9\u00871\u0086D\"\x01\u00C30P\u00AB\u00D5\u00D8K\u00D0|>\u00A7\u00C5b\x01\u00D7u\u00C3\u00C2(\u00A5\u00D3i\x14\n\x05\u0098\u00A6\u00C9\x1E@\u00C3\u00E1\u0090&\u0093\u0089\x02\u00E0\u00B9d2\t\u00DF\u00F7q:\u009D\x1Er\u00F9|\x1E\u00EDv\u009B)\u00CD\u00AEV\u00AB,\bd2\u0099p\x7F\u00B9\\\u0090\u00CB\u00E5\u00D0\u00E9t0\x1A\u008D\u0090\u00CDfq>\u009F\u00C3\\<\x1EG\u00A5R\u00B9A\"{\u00E48\x0E5\x1A\r\u00F4\u00FB\u00FD\u00DB\u00E9\\\u0096e\u00A1\u00DB\u00ED\u00A2\u00D5j\u00B1?\u00C7_*\u0095(\u00F8w\u00AC\u00D7kl\u00B7[h\u009A\u0086X,\u0086\u00CDf\u0083\u00E9t\u008Az\u00BD\u008Er\u00B9\u00FCx:?\u008D\x07\x07\x1C\u008FG\u00F2</|\u008A\u0098\u00CDfd\u00DB\u00B6\u00F2N\u00F8\u008A\u00C5\"\u0089\u00FA\x1B(\u00D0W\x10\u00DF\x02(\x17\u00DCC\u00B8\u0087{y\u00CD3P\u00EA\n\x0B\u0081\u00FC\u00F3\u00EFa2@\u0086( \t\u00A6\x00\u0083\u00E9P\u00AF\u00D7S\x00\u00C2'\u00D7*S\u00BB\u00DE\u0093\u0094\u00D4\u00C2\u00CF\u00BB\u0096\u00FEH\u00EB\u00BD<\u00D1g \u00A1T\u00C4\u00C5\u00DE\u00CB\u0083\x12\u00FA\x15`\x00\u00C5\u0093#:\u00F9a\x19\u00BD\x00\x00\x00\x00IEND\u00AEB`\u0082"; 
                var _hiddenLayers = add ("iconbutton", undefined, _hiddenLayersIcon, {style: "toolbutton", toggle: true});
                with (_hiddenLayers) {
                  size = [20,19];
                  helpTip = "Ausgeblendete Ebenen und Objekte einschließen";
                } // END iconbutton _hiddenLayers
              }
              catch (e) { 
                var _hiddenLayers = add ("checkbox", undefined, "");
                with (_hiddenLayers) {
                  helpTip = "Ausgeblendete Ebenen und Objekte einschließen";
                } // END iconbutton _hiddenLayers
              } // end Icon: Ausgeblendete Ebenen und Objekte einschließen
              // Icon: Musterseiten einbeziehen 
              try {
                var _masterPagesIcon =  "\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x12\x00\x00\x00\x11\b\x06\x00\x00\x00\u00D0Z\u00FC\u00F9\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\u00C9e<\x00\x00\x01\u00B2IDATx\u00DA\u00ACT\u00BB\u008A\x02A\x10\u00EC=.\x11\x03\x03\u00A3\u008B\u00D6@P4\x12\x04\u00BD\u00C4G\"~\u0083\u00A9\u0082\x1Fb\u00EA\u0097\u00F8\x05jd\"\u0097if\u00A4\u00E2\u0082\u00B0\u00A8(\u00BBr\u0082\u00EF\u00BE\u00A9F\u00C5\u00BD\u00F5T\x0E\x1B\u009A\u009E\u009E\u00E9\u00EA\u00A9\u00A9\u0099]\u008D\u0099\u00E9\x15\u00F6F/\u00B2\u0087\u008D*\u0095\u00CAs\u0094q\u00B4{\x1E\u008F\u00C7\u00F9Q\r\\\u00FB\u00ADQ\u00A1P\u00E0\u00F9|.c\u008F\u00C7C\u0086aP8\x1C\u0096\\\u00D34Z,\x16T\u00AF\u00D7\u00B5\u00BB\u008C\u00AA\u00D5*'\u0093I>\u00DB\u00F1x\u00E4h4\u00CA\u00FB\u00FD^|\u00BB\u00DDr.\u0097\u00E3r\u00B9\u00ECb\u00F9~nX*\u0095\u00B8\u00DF\u00EF\u00D3f\u00B3\u0091\\5\u0091\u00B8\u00DB\u00EDd\u008CbD\u00B0j4\x1A\x14\b\x04x4\x1A]\u0098]\x1A\u00ADV+j\u00B5Z\x17\u00C09\u00C2\x15\x1B\u00C9\x11k\u00B5\x1A\x1D\x0E\x07\u008A\u00C5bh\u00AA\u00ABy\u00C3qk^\u00AFW@\u00DDn\u0097\u00F2\u00F9<u:\x1D\x01\x02\x04V\u00C83\u0099\u008CD\u00CC\u0081\u00D9I7\u009FC\u00A3b\u00B1(:d\u00B3Y^\u00AF\u00D7\u009CN\u00A7\u00D9\u00B6m\u00D6u\u009Dg\u00B3\x19G\"\x11\u009EL&\u00EC\u00F7\u00FB\u00D94M\u00C6\u00D1\x14\\W\u00EEsh\x04\u00C3N\u00D0(\u0095J\t\x0B0R\x02K\u009CN\u00A7\x14\f\x06%G\u00DDr\u00B9\u00FC\u00FBA\x02`Y\x165\u009BMR\u00BB\x0B\b\u008Dqd\u00CC\u00F7z\u00BD\u00E7\x1B\u00B5\u00DBma\x03\u00AD`h\x04\u00E0`0\u0090\u00F5\u00E1p\u00E8\u00D0\u00C8uk\u00E3\u00F1\u0098B\u00A1\u0090c\x11\u00C5`\u0090H$DG<F\u00E4\u00B7\u00EC\u00F2\u00B2q\u0095*|\u00B8\n4\u00EDK\u00D5|\u00DE\u00C0\u009A\u00A7h\u00A9u\u00FB\u00FAh\u00D6i\u00D1\u00E1\u00EA\u00A3\u00A5\x1B\u00F3\u00DFW\x18\x17#\x04\u00DF?\u00FE 6z\u00FC\b0\x00\u00ACr\u0094t\u00B7\x06s:\x00\x00\x00\x00IEND\u00AEB`\u0082";
                var _masterPages = add ("iconbutton", undefined, _masterPagesIcon, {style: "toolbutton", toggle: true});
                with (_masterPages) {
                  size = [20,19];
                  helpTip = "Musterseiten einbeziehen";
                } // END iconbutton _masterPages
              }
              catch (e) { 
                var _masterPages = add ("checkbox", undefined, "");
                with (_masterPages) {
                  helpTip = "Musterseiten einbeziehen";
                } // END iconbutton _masterPages
              } // end Icon: Musterseiten einbeziehen
              // Icon: Fußnoten einbeziehen
              try {
                var _footnotesIcon = "\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x12\x00\x00\x00\x11\b\x06\x00\x00\x00\u00D0Z\u00FC\u00F9\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\u00C9e<\x00\x00\x00\u00F7IDATx\u00DA\u00AC\u0093M\x0E\u0083 \x10\u0085\u00A11q\u00D9\u009E\u00CA;x\x057\u00BA\u00D5\u00ADQ\u0097F\u00E3\u0089\u00BC\u0084\u00D7(\x1B\u00E3\u00BF\u00F5\u0091b\u00D0\u00B6b\r/!\x03\u00C8|\u0099\u00C7\b\u009D\u00E7\u0099\u00E8\u00D0\u008Dh\u0092!/\u00B2,\u00FB\u00AB<\u00CF\u00F3\x1EK`pe\u00EC?\u00BA\u00AE\u00FB3Q\u00BE\u0086<\u00CF\x11\x1E\u00EF%\u00DBXk\u00DBV\u008F5Y\u00BE\u00EF\u00F3H)\u00DDT\u0083\x18\u00C7\u00F1yP\u0092$\x1F\x00\u008Ci\u009A\u00C80\fj\u0090H\f\u0082`\u00B3\x1F\u0086!\u0087@J\x10l\bP\x14Ek\x15\u00A2\x12y\x1C\u0082D\u00D2~>\u008E\u00E3\n\u00DBw\u00EF+\u00C84MR\x14\u0085\u009E\u00AEY\u0096\u00C5\u00A3\u00B0\u0080\u00FB\u00C0\x10\u00EB\u00BE\u00EFI\u00D34\u00A4\u00AA\u00AAc\x10\x0EBi\u009A\u00AEv\u00845D@m\u00DBVW\u0084\u00C3\u0090\u00E38<\t`D\u00EC\u00E3\u0087\u00AD\u00EB\u009At]\u00A7\x06\u0095ey\u00E9\u008E\u00A8\u00DC\u0081\u00A5\u00FDw\u00E9\u00FD\u009C\u00D5sa\u00B0}E\u00EC\u00EA[{\t0\x00N\x16\u00C4\x0Bk\u00DB\u0090o\x00\x00\x00\x00IEND\u00AEB`\u0082"; 
                var _footnotes = add ("iconbutton", undefined, _footnotesIcon, {style: "toolbutton", toggle: true});
                with (_footnotes) {
                  size = [20,19];
                  helpTip = "Fußnoten einbeziehen";
                } // END iconbutton _footnotes
              }
              catch (e) { 
                var _footnotes = add ("checkbox", undefined, "");
                with (_footnotes) {
                  helpTip = "Fußnoten einbeziehen";
                } // END iconbutton _footnotes
              } // end Icon: Fußnoten einbeziehen
              add ("statictext", undefined, "Durchsuchen:");
              var _places = add ("dropdownlist", undefined, ["Gesamtes Dokument", "Textabschnitt", "Textrahmen", "Tabellen", "Auswahl"]);
              with (_places) {
                selection = 0;
              } // END dropdownlist _places
            } // END group _placesGroup
          } // END group _findPanelColumnLeft
          var _findPanelColumnRight = add ("group");       
          with (_findPanelColumnRight) {
            orientation = "column";
            spacing = 10;
            var _findButton = add ("button", undefined, "Suchen", {name: "ok"});
            var _exitButton = add ("button", undefined, "Fertig");
            with (_exitButton) {
              alignment = "right";
            } // END button _exitButton
          } // END group _findPanelColumnRight
        } // END panel _findPanel    
        var _changePanel = add ("panel",undefined,"");    
        with (_changePanel) {
          orientation = "row";
          alignChildren = ["right","fill"];
          margins = [13,15,13,4];
          var _changePanelColumnLeft = add ("group");       
          with (_changePanelColumnLeft) { 
            orientation = "column";
            spacing = 5;
            var _changeGroup = add ("group");
            with (_changeGroup) {
              spacing = 0;
              margins.right = 2;
              var _suchen = add ("statictext", undefined, "Ändern in:");
              var _changeGrep = add ("edittext", undefined, "", {multiline: false});
              with (_changeGrep) {           
                characters = 42;
              } // END edittext _changeGrep
              // Icon Sonderezeichen fuer Suche einfuegen
              try {
                var _wildcardsChangeIcon = "\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x14\x00\x00\x00\x14\b\x06\x00\x00\x00\u008D\u0089\x1D\r\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\u00C9e<\x00\x00\x03\\IDATx\u00DA\u0094UiO\x13Q\x14=\u00A5\u00D3\r\u00A1\u0094\u0096VP[\x04\u0095j\x14TD\u00A3\u00D6\u0095\u0080\x0B\u00AEiP\"FcL\u0094\x18\u00F5\u0093\x1F4\u00FE\x00\u00E3o\u00D0\u00F8A\u00A3\x01\u008DF\u00A3\u0082\x0BKb\x10\u00D0*\x10q\u00AB\u00D6\u00A5\u00A1 `J\u00B5S(\u00D3R\u00A8\u00F7\u008D:f,\u009Ap\u009B3\u00EF\u00F6\u00E6\u00DD3\u00E7\u00BDw\u00DF\x1DEee%\u00C8\u00E6\x10\u00CE\x12J\bzL\u00CExB\x03\u00E1\x14\u00C1\u00C3\u00D1\u00C3\u009E\u0092\u0092\u00EA..)E\u00E1\u0092\u00A5HNN\u009E\x14[8\x1C\u00D6w\u00B4?s65\u00D4;\u0087\u0086Bs\u0095\u00F9\u00F9\u00F9\u00E76n*\u009B\u00E7p\u00AC\x02\u00C7)\x11\u008F\u008FO\n,\u00C7j\u00B5\u0089\u00FE\x07\u008Fg\x1ASXb\u009F\u009F\u008Fa!\u00FAO\x15!\u009EG\u0090\x0FB\u00A3\u00D1\u00C0l\u00B6L8g\u00FE\u00C2B\u00DC\u00AB\u00AB\u00DD\u00C0\u0089{\u00A6PbD\u0088$L\u00EA\u00ED\u00ED\u00C1\u00C3\u00FBu\u00E8\u00F6z\u00A5X\u0086\u00D9\u008C\u00CD[\u00B7#7w\u0096|2q\u0090\u00A50B\u008C\u008E\u008E&\u0090\u00B9\u00DF\u00BE\u00C1\u00F5\u00AB\u00D5\u00B0eg\u00C3\u00B9\u00AB\x02z}\x1AxR\u00E9z\u00D2\u008A\u008B\x17\u00CEc\u00EF\u00FE\x03\u00C8\u00F9\u009B\u0094L$\u008C\u00C5\u00C6d\u00C1\u00A1P\bwo\u00DF\u00C2\u00EC<;\u00CAw\u00EF\u0091\u00E2\u0096\u00A9\u0099\u00F4\u0082\x1C\\\u00AD\u00BE\u008C{\u00B5wp\u00F8\u00C8\u00F1\x7F\x10\u008E\u00C9\t[Z\u009A1>\x1EG\u00D9\u00B6\u009D\x18\u00F8:\u0080\u00A7\u00AD-H3\x18 \b\x02\u00AC6\x1BV8V\u00A3\u00E6\u00CA%\u00F8|\u00DD\u00C8\u009A6=\u0091P\x18\x11d\u00C1\x17\u009D\x1DX\\X$\u00C6\u00D9\u00F2\u0098\u00E9\u00A8\u009C\x02~?,\u0096r\u00D8l9\x18\u00A3U}\u00FE\u00F4\x11\u00E9\u00E9\u00A6D\u00C2>\x7F@\n|\u00FF\x16\u0080?\x10\u0080jJ*\u00DA\\.\u00D1\u00DF\u00B9k\x0F\x06\u00FA\u00FB\u00E0\u00EB\u00E9A\u008C6\u009F\u00CD\x1F&\u00B5\u0083\u00C1\u0090,\u0097Y\x12{\u008CS\r\u00FDF$\x1AA\u009C~\u009CJE\n<\u00A2o\u00A2R\t\u00D1\u00810_OK\x0F\x04\x06E\u00DF\u0090n\u0094\u00E5J\n9N\u00F5G\u00B2\u0092C\u0092\"I\x1C\r\x06#|\u008A\u00CF\u00E8\u00EAx\u008EO\u009E\u00F7b\u00FC\u00DB\u00E0 \u009E<~\x04\u0093\u00C9\f\u00DB\u00CC\u00DC\u0084C\x11\x15j\u00D4\x1A\t3\u00AC\u00D9P*\u0095\u00E8\u00FF\u00D2\u0083\u00A5\u00CB\x1DTwS\u00E1\u00A5\u00BD*\u00DEP\x06\u00BA\u00A2\u00B8}\u00A3F,\u00B3-;\u00CAey\f\u0092B\u009DN-{K\u00C1\u00A2\u00C5x\u00FB\u00EA\x05\x16\x14\x14\u00E0`\u00D5\x11)>\u00C7\u009EG\n\u00FD\x18\x0E\u00F1\u0088E\u00C3\u0094\u00975\u00B1B\u009DV+\u00C3\u00AA5\u00EBh\x1B8\u00DC\u00BCV\u008D\u008F\u00EF\u00DD\b\u00D2\u00C1|\u00A5Cy\u00DD\u00D5\u0089\u00999\u00B9\u0088\u008DFQKJ]\u00CDMP\u00AB8)OR\u0098:%E\u00F6\x16\u00F6\u00FFP\u00D5Q45<@\u00E3\u0083\u00BA?\u00D7.\u00C3\x02\u00C7\u00CA5\u00D0\u008A\u00CB\u008B\u00A3\u00FDi+\u00A2\u0091\b\u009C\x15\u00FBde\u00C3'k\u00B5z\u00DD_m\u00CBd4\"\u008Fn\nO\u008D\u0081\x0F~\u00A7\u00C6\u00A0\u0085\u00D9\u00F2\u00B31\u00F8\u00BC\x1F\u00C4q\u00E5\u00EA\u00F5p\u00EE\u00DE\x0B\u00B5Z\u008D\u0091pX\u00BCd\u008C\u00B0\u00E1\u009D\u00FB\u00A5smq\u00E9\u0084]$\u00CD\u00C0\u00FA\u00ED\fY\u008C5\u0088\u00E3'N\u00A2h\u00D9\n)\u00F6\u00DC\u00F5\u0098\r\x0FY?\u00EC\u00EA\u00ED\u00F6\x1ES\u00AB\u0095\u00C8\u00CC\u00B2\u0090\x12*\u009B\u00A4\u00F8\x7Fa\u00CB\u00B6R5L\x17}A\x18F\x1B\u0095Q#u\u00A5h4\u00EAT\u00FC\u00FA\x04\u00D8\tg\bLf\u00EA$?\x01!B=\u00E14\u00E1\u00DD\x0F\x01\x06\x00\u00BEno\u00A9ry1O\x00\x00\x00\x00IEND\u00AEB`\u0082";
                var _wildcardsChange = add ("iconbutton", undefined, _wildcardsChangeIcon, {style: "toolbutton"});
                with (_wildcardsChange) {
                  size = [22,22];
                  helpTip = "Sonderzeichen für Ersetzung";
                } // END iconbutton _wildcardsChange
              }
              catch (e) { 
                var _wildcardsChange = add ("button", undefined, "@");
                with (_wildcardsChange) {
                  size = [22,23]
                  helpTip = "Sonderzeichen für Ersetzung";
                } // END iconbutton _wildcardsChange
              } // END Icon Sonderezeichen einfuegen
            } // END group _changeGroup      
            var _changeFormatGroup = add ("group");
            with (_changeFormatGroup) {
              alignment = "right";
              margins.bottom = 0;
              // Icon: Refresh ChangeStyles
              try {
                var _refreshCangeStylesIcon = "\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x12\x00\x00\x00\x11\b\x06\x00\x00\x00\u00D0Z\u00FC\u00F9\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\u00C9e<\x00\x00\x01=IDATx\u00DA\u00AC\u00D4=H\x03A\x10\u0086\u00E1\u00BDD4*\bZ*A\u00B1\u00B3Ke%b\u00A1\u00A0\x07\x01[\u0083\u0085\u00B5\bi\u00D2\u00A4\u00B6\u00B1\x14\x05{\x0B\x7FJA\u00B4\u00B3\u00B2S\u008BtV!\u0085\u00C4RA\u0088\x1A\u0089\u009E\u00EF\u0084\x11\u0086e\u00AF\u00F2\x16\x1E\b\u00BB\u00CBw\u00B7;sqI\u0092\u00B8\u00FF\x0E\u00C9\x18HY\u009B@\u008CyL\"\u00876\u00EEq\u00817\u00DD\u00B7\u00813\u00F9\x11IZ\x14E6d\x01;\x18\u00C5'\u009Ed\x1F\u008A\x18B\x07\x07\u0098F\x05\u00E5~\u0086\x17\u00B4\u0088\x1A\u00DEq\u008C\x1B|\u00E9\u00DA \u0096\u00B1\u0085a\u00F3\u00E0\u00B2\x7F\u00B4qlkH\x1D-\u00EF\u00B8\x12x\u00ADo\x12\u00FBwa\u0083f\u00D1\u00C3I \u00C4\u0099;\u0089C\x0B\u00FE\u00D1$X\u00CA\u00F8\x1D\u00D8+\u00F73\x17\u0098o\u00F4+\u009FU\u00F9s.\u00A3a\u00EF\u00A8\x14X\x7FD70\u009F\u00D7\u0096\u00E8\u0085\u0082v\u00BD\u00CD\u00D2h\u008D\u0094\x17X\u00C1&\u00F6\u00F1\u00E0\x07\u00D9!e>MY\u009B\u00D1^\u0092\u00D1\u00FC\u009BL\u00BB\u00A3%\u00ACi\x13:\u00D3\u0090\u00AB\u00D8\u00C3\b\u008E\u00F0\x1A*\u00FF%\u00CE\u00B5\u0087\u00AA\u00BA\u00B9\u00AB\u009FH\u00A2\u009FH\x01\x1F8\u00C4\u00AD\u00AD\u009A\r\u00AA\u0098\u00E3\u008Ca]?\u00DA)\u00FC\u00E0\x19w\u00B8\u00C2\u008B_~\u0097\u00E9\u00DFH\x16a\u00BF\x02\f\x00\u00BD/g\u00CDu\u00B8\u009C'\x00\x00\x00\x00IEND\u00AEB`\u0082";
                var _refreshChangeStyles = add ("iconbutton", undefined, _refreshCangeStylesIcon, {style: "toolbutton"});
                with (_refreshChangeStyles) {
                  size = [24,24];
                  helpTip = "Zeichen- und Absatzformate aktualisieren";
                } // END iconbutton _refreshChangeStyles
              }
              catch (e) { 
                var _refreshChangeStyles = add ("button", undefined, "R");
                with (_refreshChangeStyles) {
                  size = [24,24];
                  graphics.font = "dialog:11";
                  helpTip = "Zeichen- und Absatzformate aktualisieren";
                } // END button _refreshChangeStyles
              } // end Icon: Refresh ChangeStyles   
              var _changeCharacterStyles = add ("dropdownlist", undefined, _doc.characterStyles.everyItem().name);
              with (_changeCharacterStyles) {
                graphics.font = "dialog:11";
                graphics.foregroundColor = graphics.newPen (graphics.PenType.SOLID_COLOR, [0.13, 0.13, 0.13], 1);
              } // END dropdownlist _changeCharacterStyles
              var _changeParagraphStyles = add ("dropdownlist", undefined, _doc.paragraphStyles.everyItem().name);
              with (_changeParagraphStyles) {
                graphics.font = "dialog:11";
                graphics.foregroundColor = graphics.newPen (graphics.PenType.SOLID_COLOR, [0.13, 0.13, 0.13], 1);
              } // END dropdownlist _changeParagraphStyles
              writeStyleItems (_changeCharacterStyles, _changeParagraphStyles);
            } // END group _changeFormatGroup         
          } // END group _changePanelColumnLeft  
          var _changePanelColumnRight = add ("group");       
          with (_changePanelColumnRight) { 
            alignment = "fill";
            alignChildren = "top";
            var _changeButton = add ("button", undefined, "Ändern");
            with (_changeButton) {
              helpTip = "Ändert alle Fundstellen!";
            } // END button _changeButton
          } // END group _changePanelColumnRight       
        } // END panel _changePanel         
      } // END group _columnRight
    } // END window _palette
    
    // Callbacks ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    _inputGrep.onChanging = function() { 
      __initiateSearch ();
    }

    // Sonderzeichen fuer Suche einfuegen
    _wildcardsFind.onClick = function () {     
      var _textselection = _inputGrep.textselection;
      if (_inputGrep.active == true) {   
        _inputGrep.textselection = "(?#textselection?)";
      } else {
        _inputGrep.text += "(?#textselection?)";
      }
      var _selectedWildcardForFind = __getWildcardsForFind ();     
      if (_selectedWildcardForFind!="") {
        switch (_selectedWildcardForFind) {
          case "()" :
            _textselection = "("+_textselection+")";
            _inputGrep.text = _inputGrep.text.replace(/\(\?#textselection\?\)/,_textselection);
            break;
          case "[]" :
            _textselection = "["+_textselection+"]";
            _inputGrep.text = _inputGrep.text.replace(/\(\?#textselection\?\)/,_textselection);
            break;
          case "[^]" :
            _textselection = "[^"+_textselection+"]";
            _inputGrep.text = _inputGrep.text.replace(/\(\?#textselection\?\)/,_textselection);
            break;         
          case "(?<=)" :
            _textselection = "(?<="+_textselection+")";
            _inputGrep.text = _inputGrep.text.replace(/\(\?#textselection\?\)/,_textselection);
            break;
          case "(?<!)" :
            _textselection = "(?<!"+_textselection+")";
            _inputGrep.text = _inputGrep.text.replace(/\(\?#textselection\?\)/,_textselection);
            break;
          case "(?=)" :
            _textselection = "(?="+_textselection+")";
            _inputGrep.text = _inputGrep.text.replace(/\(\?#textselection\?\)/,_textselection);
            break;
          case "(?!)" :
            _textselection = "(?!"+_textselection+")";
            _inputGrep.text = _inputGrep.text.replace(/\(\?#textselection\?\)/,_textselection);
            break;         
          case "(?#comment?)" :
            if (_textselection!="") {
              _textselection = "(?#"+_textselection+"?)";
              _inputGrep.text = _inputGrep.text.replace(/\(\?#textselection\?\)/,_textselection);
            } else {
              _inputGrep.text = _inputGrep.text.replace(/\(\?#textselection\?\)/,_selectedWildcardForFind);
            }
            break;
          default :
            _inputGrep.text = _inputGrep.text.replace(/\(\?#textselection\?\)/,_selectedWildcardForFind);
        } // END switch _selectedWildcardForFind
      } else {
        _inputGrep.text = _inputGrep.text.replace(/\(\?#textselection\?\)/,_textselection);
      } 
      __initiateSearch ();
    }
    
    // Sonderzeichen fuer Ersetzung einfuegen
    _wildcardsChange.onClick = function () {          
      var _textselection = _changeGrep.textselection;
      if (_changeGrep.active == true) {   
        _changeGrep.textselection = "(?#textselection?)";
      } else {
        _changeGrep.text += "(?#textselection?)";
      }
      var _selectedWildcardForChange = __getWildcardsForChange ();
      if (_selectedWildcardForChange!="") {
        _changeGrep.text = _changeGrep.text.replace(/\(\?#textselection\?\)/,_selectedWildcardForChange);
      } else {
        _changeGrep.text = _changeGrep.text.replace(/\(\?#textselection\?\)/,_textselection);     
      } 
    }

    _findCharacterStyles.onChange = function() { 
      __initiateSearch ();
    }
  
    _findParagraphStyles.onChange = function() { 
      __initiateSearch ();
    }
  
    _places.onChange = function() { 
      __initiateSearch ();     
    } 
  
    // Initiate Search if Live-Modus is on
    function __initiateSearch () {
      _sc = 0;
      if (_live.value == true) {
        var _onChangeCondition = true;
        var _findOrChange = "find";
        _hits = _getGrep (_onChangeCondition, _findOrChange); 
        if (_hits == null) _numberOfHits.text = 0; else _numberOfHits.text = _hits; 
      } else { 
        _onChangeCondition = false;    
      }
    }
  
    _findButton.onClick = function() { 
      alertConditionalText (); 
      _sc = 0;
      var _onClickCondition = true;
      var _findOrChange = "find";
      _hits = _getGrep (_onClickCondition, _findOrChange); 
      if (_hits == null) _numberOfHits.text = 0; else _numberOfHits.text = _hits; 
    }  
  
    _changeButton.onClick = function() { 
      alertConditionalText (); 
      _sc = 0;
      var _onClickCondition = true;
      var _findOrChange = "change";
      _hits = _getGrep (_onClickCondition, _findOrChange); 
      if (_hits == null) _numberOfHits.text = 0; else _numberOfHits.text = _hits; 
    } 
  
    _copyButton.onClick = function ()  {
      app.doScript(copyButtonOnClick, ScriptLanguage.JAVASCRIPT , [], UndoModes.ENTIRE_SCRIPT, "Fundstellen kopieren");
      function copyButtonOnClick () {
        var _resultStrings = [];     
        var _resultsToCopy = findHits ();   
        if (_resultsToCopy.length>0) {           
          for (var i=0; i<_resultsToCopy.length; i++) {   
            _resultStrings.push(_resultsToCopy[i].contents);        
          }   
          var _textForClipboard = _resultStrings.join("\t");
          var _firstPage = app.activeDocument.pages[0];
          try {
            var _tempLayer = app.activeDocument.layers.add({name:"::tempLayer::"});
            _tempLayer.visible = false;
            var _tempTF = app.activeDocument.textFrames.add(_tempLayer,undefined,_firstPage, {name:"::tempTF::"});
            var _firstPageBounds = _firstPage.bounds;
            _tempTF.visibleBounds = _firstPageBounds; 
            _tempTF.contents = _textForClipboard;      
            app.activeDocument.select(_tempTF.texts);
            app.copy(); 
            alert("Folgende Fundstelle(n) wurden in die Zwischenablage kopiert:\r" + _textForClipboard);
          } catch (e) { _copyFailed (); } 
          try { 
            _tempTF.remove();
            _tempLayer.remove();
          } 
          catch (e) { _copyFailed (); } 
        } else {
          _copyFailed ();
        }
       
        function _copyFailed () {
          alert("Die Fundstelle(n) konnte(n) nicht in die Zwischenablage kopiert werden!\r" +
                "Mögliche Ursachen:\r"+
                "- Keine Fundstellen im Dokument vorhanden\r"+
                "- Suche wurde noch nicht ausgeführt"); 
        }
      }
    }
  
    _selectionButton.onClick = function ()  {  
      var _resultsToSelect = findHits ();
      if (_resultsToSelect.length > 0) {
        if (_sc >= _resultsToSelect.length) { 
          _sc = 0; 
        }
        try { showIt (_resultsToSelect[_sc]); } catch (e) { alert ("Treffer im Übersatztext oder auf einer Musterseite!"); } // showIt: Fehler bei Übersatztext
        _sc += 1;
        if (_sc >= _resultsToSelect.length && _resultsToSelect.length > 1) { alert ("Letzte Fundstelle erreicht."); }
      } else {
        alert("Keine Übereinstimmungen im Dokument vorhanden!");
      }       
    }

    _clearConditionButton.onClick = function ()  {
      _sc = 0;
      delConditions (); 
    }
  
    _refreshFindStyles.onClick = function () {  
      var _checkLiveValue = _live.value;
      if (_checkLiveValue) {
        _live.value = false;
      }
      writeStyleItems (_findCharacterStyles, _findParagraphStyles);
      _live.value = _checkLiveValue;
    }
  
    _refreshChangeStyles.onClick = function () {         
      writeStyleItems (_changeCharacterStyles, _changeParagraphStyles);
    }
  
    _exitButton.onClick = function ()  {
      delConditionsInAllDocs (); 
      _palette.close(0);
    }
  
    _palette.onClose = function () {
      _sc = 0;
      delConditionsInAllDocs ();
    }
    // end Callbacks ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  
    function writeStyleItems (_cStyles, _pStyles) { 
      
      var _doc = app.activeDocument;
      with (_cStyles) {        
          removeAll();
          add ("item", "Zeichenformat: leer", 0);
          add ("separator", undefined, 1);
          for (var i=0; i<_doc.allCharacterStyles.length; i++) { 
            var _cs = _doc.allCharacterStyles[i];
            if (_cs.parent.constructor.name == "CharacterStyleGroup") {            
              if (_cs.parent.parent.constructor.name == "CharacterStyleGroup") {
                add ("item", _cs.parent.parent.name + " > " + _cs.parent.name + " > " + _cs.name); 
                _cs.label = _cs.parent.parent.name + " > " + _cs.parent.name + " > " + _cs.name;
              } else { 
                add ("item", _cs.parent.name + " > " + _cs.name);
                _cs.label = _cs.parent.name + " > " + _cs.name;
              }
            } else {  
              add ("item", _cs.name);
              _cs.label = _cs.name;
            }
          }
          selection = 0;
        } 
      with (_pStyles) {     
        removeAll();
        add ("item", "Absatzformat: leer", 0);
        add ("separator", undefined, 1);
        for (var j=0; j<_doc.allParagraphStyles.length; j++) {
          var _ps = _doc.allParagraphStyles[j];
          if (_ps.parent.constructor.name == "ParagraphStyleGroup") {            
            if (_ps.parent.parent.constructor.name == "ParagraphStyleGroup") {
              add ("item", _ps.parent.parent.name + " > " + _ps.parent.name + " > " + _ps.name); 
              _ps.label = _ps.parent.parent.name + " > " + _ps.parent.name + " > " + _ps.name;
            } else { 
              add ("item", _ps.parent.name + " > " + _ps.name);
              _ps.label = _ps.parent.name + " > " + _ps.name;
            }
          } else {  
              add ("item", _ps.name);
              _ps.label = _ps.name;
          }  
        }
        selection = 0;
      }
    }
  
    function __getWildcardsForFind() {

      // Wildcard Object for Search
      var _wildcardsForFind = {
        "Tabulator": "\\t", 
        "Harter Zeilenumbruch": "\\n",
        "Absatzende": "\\r",
        "Leerzeichen (über die Schriftart definiert)":"[ ]",
        "Aufzählungszeichen":"~8",
        "Umgekehrter Schrägstrich":"\\\\",
        "Caret-Zeichen":"\\^",
        "Copyright-Symbol":"~2",
        "Auslassungszeichen (Ellipse)":"~e",
        "Absatzmarke":"~7",
        "Eingetragene Marke":"~r",
        "Paragraphenzeichen":"~6",
        "Trademark-Symbol":"~d",
        "Runde Klammer auf":"\\(",
        "Runde Klammer zu":"\\)",
        "Geschweifte Klammer auf":"\\{",
        "Geschweifte Klammer zu":"\\}",
        "Eckige Klammer auf":"\\[",
        "Eckige Klammer zu":"\\]",
        "Alle Seitenzahlen":"~#",
        "Aktuelle Seitenzahl":"~N",
        "Nächste Seitenzahl":"~X",
        "Vorherige Seitenzahl":"~V",
        "Abschnittsmarke":"~x",
        "Marke für verankertes Objekt":"~a",
        "Marke für Fußnotenverweis":"~F",
        "Indexmarke":"~I",
        "Verschachteltes Format hier beenden":"~h",
        "Geviertstrich":"~_",
        "Halbgeviertstrich":"~=",
        "Bindestrich":"\\-",
        "Bedingter Trennstrich":"~-",
        "Geschützter Trennstrich":"~~",
        "Geviert":"~m",
        "Halbgeviert":"~>",
        "Drittelgeviert":"~3",
        "Viertelgeviert":"~4",
        "Sechstelgeviert":"~%",
        "Achtelgeviert":"~<",
        "Ausgleichsleerzeichen":"~f",
        "1/24-Geviert":"~|",
        "Geschützes Leerzeichen":"~S",
        "Geschütztes Leerzeichen (feste Breite)":"~s",
        "Interpunktionsleerzeichen":"~.",
        "Ziffernleerzeichen":"~/",
        "Alle doppelten Anführungszeichen":"\"",
        "Alle einfachen Anführungszeichen (Apostroph)":"\'",
        "Gerade doppelte Anführungszeichen":"~\"",
        "Öffnende doppelte Anführungszeichen":"~{",
        "Schließende doppelte Anführungszeichen":"~}",
        "Gerades einfaches Anführungszeichen (Apostroph)":"~\'",
        "Öffnendes einfaches Anführungszeichen":"~[",
        "Schließendes einfaches Anführungszeichen":"~]",
        "Alle Umbruchzeichen (außer harter Zeilenumbruch)":"\\r",
        "Standardzeilenumbruch":"~b",
        "Spaltenumbruch":"~M",
        "Rahmenumbruch":"~R",
        "Seitenumbruch":"~P",
        "Umbruch für ungerade Seiten":"~L",
        "Umbruch für gerade Seiten":"~E",
        "Bedingter Zeilenumbruch":"~k",
        "Alle Variablen":"~v",
        "Lebender Kolumnentitel (Absatzformat)":"~Y",
        "Lebender Kolumnentitel (Zeichenformat)":"~Z",
        "Benutzerdefinierter Text":"~u",
        "Alle Seitenzahlen":"~#",
        "Automatische Seitenzahl":"~N",
        "Nächste Seitenzahl":"~X",
        "Vorherige Seitenzahl":"~V",
        "Letzte Seitenzahl":"~T",
        "Kapitelnummer":"~H",
        "Erstellungsdatum":"~O",
        "Änderungsdatum":"~o",
        "Ausgabedatum":"~D",
        "Dateiname":"~l",
        "Metadatenbeschriftung":"~J",
        "Tabulator für rechte Ausrichtung":"~y",
        "Einzug bis hierhin":"~i",
        "Verschachteltes Format beenden":"~h",
        "Verbindung unterdrücken":"~j",
        "Beliebige Ziffer":"\\d",
        "Beliebiger Buchstabe":"[\\u\\l]",
        "Beliebiges Zeichen":".",
        "Beliebiges Zeichen (inklusive Umbruchzeichen)":"\\X",
        "Alle Leerräume":"\\s",
        "Alle Wortzeichen":"\\w",
        "Alle Großbuchstaben":"\\u",
        "Alle Kleinbuchstaben":"\\l",
        "Alle Umbruchzeichen":"\\r",
        "Alle Zeichen innerhalb der eckigen Klammer":"[]",
        "Eigene Zeichenklasse negieren":"[^]",
        "Unicode-Codepoint":"\\x{####}",
        "Unicode-Name 1":"\\N{Unicode-Name}",
        "Unicode-Name 2":"[[.Unicode-Name.]]",
        "Absatzbeginn":"^",
        "Absatzende":"$",
        "Wortbeginn":"\\<",
        "Wortende":"\\>",
        "Wortgrenze":"\\b",
        "Keine Wortgrenze":"\\B",
        "Anfang des Textabschnittes":"\\A",
        "Ende des Textabschnittes":"\\b",
        "Null oder ein Mal":"?",
        "Null oder mehrere Male":"*",
        "Ein oder mehrere Male":"+",
        "Null oder ein Mal (kürzeste Entsprechung)":"??",
        "Null oder mehrere Male (kürzeste Entsprechung)":"*?",
        "Ein oder mehrere Male (kürzeste Entsprechung)":"+?",
        "n-mal":"{n}",
        "mindestens n-mal maximal m-mal":"{n,m}",
        "n-mal oder öfter":"{n,}",
        "n-mal oder öfter (kürzeste Entsprechung)":"{n,m}?",
        "Markierter Unterausdruck":"()",
        "Nicht markierter Unterausdruck (Fundstelle nicht markieren)":"(?:)",
        "Zeichensatz":"[]",
        "Oder":"|",
        "Positives Lookbehind":"(?<=)",
        "Negatives Lookbehind":"(?<!)",
        "Positives Lookahead":"(?=)",
        "Negatives Lookahead":"(?!)",
        "Nicht zwischen Groß- und Kleinschreibung unterscheiden":"(?i)",
        "Zwischen Groß- und Kleinschreibung unterscheiden":"(?-i)",
        "Mehrere Zeilen ein":"(?m)",
        "Mehrere Zeilen aus":"(?-m)",
        "Gesamten Textabschnitt durchsuchen":"(?s)",
        "Innerhalb eines Absatzes suchen":"(?-s)",
        "Leerzeichen im Ausdruck ignorieren":"(?x)",
        "Leerzeichen im Ausdruck nicht ignorieren":"(?-x)",
        "Kommentar":"(?#comment?)",
        "Buchstaben und Zahlen":"[[:alnum:]]",
        "Groß- und Kleinbuchstaben":"[[:alpha:]]",
        "Leerzeichen und Tabulator":"[[:blank:]]",
        "Zahlen":"[[:digit:]]",
        "Kleinbuchstaben":"[[:lower:]]",
        "Großbuchstaben":"[[:upper:]]",
        "Satzzeichen":"[[:punct:]]",
        "Sichtbare Zeichen":"[[:graph:]]",
        "Leerzeichen":"[[:space:]]",
        "Wortzeichen":"[[:word:]]",
        "Hexadezimale Ziffer":"[[:xdigit:]]",
        "Buchstabenäquivalent (alle Formen eines Buchstabens)":"[[:=a=:]]",
        "letter (Alle Buchstaben)":"\\p{L*}",
        "lowercase_letter (alle Kleinbuchstaben)":"\\p{Ll}",
        "uppercase_letter (alle Großbuchstaben)":"\\p{Lu}",
        "titlecase_letter (Anfangsbuchstaben)":"\\p{Lt}",
        "modifier_letter (Diakritische Zeichen)":"\\p{Lm}",
        "letter_other (restlichen Buchstaben)":"\\p{Lo}",
        "separator (Leerräume und Umbruchzeichen ohne Tabulator)":"\\p{Z*}",
        "space_separator (Leerräume ohne Umbruchzeichen ohne Tabulator)":"\\p{Zs}",
        "line_separator (XML-Export)":"\\p{Zl}",
        "paragraph-separator (XML-Export)":"\\p{Zp}",
        "symbol":"\\p{S*}",
        "math_symbol":"\\p{Sm}",
        "currency_symbol (Währungssymbole)":"\\p{Sc}",
        "modifier_symbol (Bedeutungsverändernde Symbole wie Akzente)":"\\p{Sk}",
        "other_symbol":"\\p{So}",
        "number (alle Ziffern)":"\\p{N*}",
        "decimal_digit_number (Ziffern von 0-9)":"\\p{Nd}",
        "letter_number (Römische Ziffern mit den Codepoints 2150-218F)":"\\p{Nl}",
        "other_numbers (hoch- und tiefgestellte Ziffern und Brüche)":"\\p{No}",
        "punctation (Satzzeichen Striche Anführungszeichen)":"\\p{P*}",
        "dash_punctuation (ohne Trennstriche)":"\\p{Pd}",
        "open_puntuation":"\\p{Ps}",
        "close_punctuation":"\\p{Pe}",
        "initial_punctuation (öffnende Anführungszeichen aber keine Zollzeichen)":"\\p{Pi}",
        "final_punctuation (schließende Anführungszeichen aber keine Zollzeichen)":"\\p{Pf}",
        "other_punctuation":"\\p{Po}"
      }

      // Wildcards Dialog for Search
      var _selectWildcardsForFind = new Window ("dialog","Sonderzeichen für Suche");
      with (_selectWildcardsForFind) {
        alignChildren = "right";
        var _wildcardsForFindTree = add ("treeview");
        with (_wildcardsForFindTree) {
          preferredSize = [380,430];
          itemSize = [560,20];
          add ("item","Tabulator"); 
          add ("item","Harter Zeilenumbruch");
          add ("item","Absatzende");

          var _symbols = add ("node", "Symbole");
          with (_symbols) {
            add ("item","Leerzeichen (über die Schriftart definiert)");
            add ("item","Aufzählungszeichen");
            add ("item","Umgekehrter Schrägstrich");
            add ("item","Caret-Zeichen");
            add ("item","Copyright-Symbol");
            add ("item","Auslassungszeichen (Ellipse)");
            add ("item","Absatzmarke");
            add ("item","Eingetragene Marke");
            add ("item","Paragraphenzeichen");
            add ("item","Trademark-Symbol");
            add ("item","Runde Klammer auf");
            add ("item","Runde Klammer zu");
            add ("item","Geschweifte Klammer auf");
            add ("item","Geschweifte Klammer zu");
            add ("item","Eckige Klammer auf");
            add ("item","Eckige Klammer zu");
          }
          // Marken
          var _marks = add ("node","Marken");
          with (_marks) {
            add ("item","Alle Seitenzahlen");
            add ("item","Aktuelle Seitenzahl");
            add ("item","Nächste Seitenzahl");
            add ("item","Vorherige Seitenzahl");
            add ("item","Abschnittsmarke");
            add ("item","Marke für verankertes Objekt");
            add ("item","Marke für Fußnotenverweis");
            add ("item","Indexmarke");
            add ("item","Verschachteltes Format hier beenden");
          }
          // Trenn- und Gedankenstriche
          var _dashes = add ("node","Trenn- und Gedankenstriche");
          with (_dashes) {
            add ("item","Geviertstrich");
            add ("item","Halbgeviertstrich");
            add ("item","Bindestrich");
            add ("item","Bedingter Trennstrich");
            add ("item","Geschützter Trennstrich");
          }
          // Leerraum
          var _spaces = add ("node","Leerraum");
          with (_spaces) {
            add ("item","Geviert");
            add ("item","Halbgeviert");
            add ("item","Drittelgeviert");
            add ("item","Viertelgeviert");
            add ("item","Sechstelgeviert");
            add ("item","Achtelgeviert");
            add ("item","Ausgleichsleerzeichen");
            add ("item","1/24-Geviert");
            add ("item","Geschützes Leerzeichen");
            add ("item","Geschütztes Leerzeichen (feste Breite)");
            add ("item","Interpunktionsleerzeichen");
            add ("item","Ziffernleerzeichen");
          }
          // Anführungszeichen
          var _puntuation = add ("node","Anführungszeichen");
          with (_puntuation) {
            add ("item","Alle doppelten Anführungszeichen");
            add ("item","Alle einfachen Anführungszeichen (Apostroph)");
            add ("item","Gerade doppelte Anführungszeichen");
            add ("item","Öffnende doppelte Anführungszeichen");
            add ("item","Schließende doppelte Anführungszeichen");
            add ("item","Gerades einfaches Anführungszeichen (Apostroph)");
            add ("item","Öffnendes einfaches Anführungszeichen");
            add ("item","Schließendes einfaches Anführungszeichen");
          }
          // Umbruchzeichen
          var _breaks = add ("node","Umbruchzeichen");
          with (_breaks) {
            add ("item","Alle Umbruchzeichen (außer harter Zeilenumbruch)");
            add ("item","Standardzeilenumbruch");
            add ("item","Spaltenumbruch");
            add ("item","Rahmenumbruch");
            add ("item","Seitenumbruch");
            add ("item","Umbruch für ungerade Seiten");
            add ("item","Umbruch für gerade Seiten");
            add ("item","Bedingter Zeilenumbruch");
          }
          // Variable
          var _variables = add ("node","Variable");
          with (_variables) {
            add ("item","Alle Variablen");
            add ("item","Lebender Kolumnentitel (Absatzformat)");
            add ("item","Lebender Kolumnentitel (Zeichenformat)");
            add ("item","Benutzerdefinierter Text");
            add ("item","Alle Seitenzahlen");
            add ("item","Automatische Seitenzahl");
            add ("item","Nächste Seitenzahl");
            add ("item","Vorherige Seitenzahl");
            add ("item","Letzte Seitenzahl");
            add ("item","Kapitelnummer");
            add ("item","Erstellungsdatum");
            add ("item","Änderungsdatum");
            add ("item","Ausgabedatum");
            add ("item","Dateiname");
            add ("item","Metadatenbeschriftung");
          }
          // Andere 
          var _others = add ("node","Andere");
          with (_others) {
            add ("item","Tabulator für rechte Ausrichtung");
            add ("item","Einzug bis hierhin");
            add ("item","Verschachteltes Format beenden");
            add ("item","Verbindung unterdrücken");
          }
          // Platzhalter
          var _placeholders = add ("node","Platzhalter");
          with (_placeholders) {
            add ("item","Beliebige Ziffer");
            add ("item","Beliebiger Buchstabe");
            add ("item","Beliebiges Zeichen");
            add ("item","Beliebiges Zeichen (inklusive Umbruchzeichen)");
            add ("item","Alle Leerräume");
            add ("item","Alle Wortzeichen");
            add ("item","Alle Großbuchstaben");
            add ("item","Alle Kleinbuchstaben");
            add ("item","Alle Umbruchzeichen");
          }
          // Eigene Zeichenklasse
          var _characterClass = add ("node","Eigene Zeichenklasse");
          with (_characterClass) {
            add ("item","Alle Zeichen innerhalb der eckigen Klammer");
            add ("item","Eigene Zeichenklasse negieren");
          }
          // Unicode
          var _unicode = add ("node","Unicode");
          with (_unicode) {
            add ("item","Unicode-Codepoint");
            add ("item","Unicode-Name 1");
            add ("item","Unicode-Name 2");
          }
          // Positionen
          var _position = add ("node","Positionen");
          with (_position) {
            add ("item","Absatzbeginn");
            add ("item","Absatzende");
            add ("item","Wortbeginn");
            add ("item","Wortende");
            add ("item","Wortgrenze");
            add ("item","Keine Wortgrenze");
            add ("item","Anfang des Textabschnittes");
            add ("item","Ende des Textabschnittes");
          }
          // Wiederholung
          var _repeatings = add ("node","Wiederholung");
          with (_repeatings) {
            add ("item","Null oder ein Mal");
            add ("item","Null oder mehrere Male");
            add ("item","Ein oder mehrere Male");
            add ("item","Null oder ein Mal (kürzeste Entsprechung)");
            add ("item","Null oder mehrere Male (kürzeste Entsprechung)");
            add ("item","Ein oder mehrere Male (kürzeste Entsprechung)");
            add ("item","n-mal");
            add ("item","mindestens n-mal maximal m-mal");
            add ("item","n-mal oder öfter");
            add ("item","n-mal oder öfter (kürzeste Entsprechung)");
          }
          // Entsprechung
          var _equivalents = add ("node","Entsprechung");
          with (_equivalents) {
            add ("item","Markierter Unterausdruck");
            add ("item","Nicht markierter Unterausdruck (Fundstelle nicht markieren)");
            add ("item","Zeichensatz");
            add ("item","Oder");
            add ("item","Positives Lookbehind");
            add ("item","Negatives Lookbehind");
            add ("item","Positives Lookahead");
            add ("item","Negatives Lookahead");
          }
          // Modifizierer
          var _modifier = add ("node","Modifizierer");
          with (_modifier) {
            add ("item","Nicht zwischen Groß- und Kleinschreibung unterscheiden");
            add ("item","Zwischen Groß- und Kleinschreibung unterscheiden");
            add ("item","Mehrere Zeilen ein");
            add ("item","Mehrere Zeilen aus");
            add ("item","Gesamten Textabschnitt durchsuchen");
            add ("item","Innerhalb eines Absatzes suchen");
            add ("item","Leerzeichen im Ausdruck ignorieren");
            add ("item","Leerzeichen im Ausdruck nicht ignorieren");
            add ("item","Kommentar");
          }
          // Posix-Ausdrücke
          var _posix = add ("node","Posix-Ausdrücke");
          with (_posix) {
            add ("item","Buchstaben und Zahlen");
            add ("item","Groß- und Kleinbuchstaben");
            add ("item","Leerzeichen und Tabulator");
            add ("item","Zahlen");
            add ("item","Kleinbuchstaben");
            add ("item","Großbuchstaben");
            add ("item","Satzzeichen");
            add ("item","Sichtbare Zeichen");
            add ("item","Leerzeichen");
            add ("item","Wortzeichen");
            add ("item","Hexadezimale Ziffer");
            add ("item","Buchstabenäquivalent (alle Formen eines Buchstabens)");
          }
          // Unicode-Properties
          var _unicodeProps = add ("node","Unicode-Properties");
          with (_unicodeProps) { 
            add ("item","letter (Alle Buchstaben)");
            add ("item","lowercase_letter (alle Kleinbuchstaben)");
            add ("item","uppercase_letter (alle Großbuchstaben)");
            add ("item","titlecase_letter (Anfangsbuchstaben)");
            add ("item","modifier_letter (Diakritische Zeichen)");
            add ("item","letter_other (restlichen Buchstaben)");
            add ("item","separator (Leerräume und Umbruchzeichen ohne Tabulator)");
            add ("item","space_separator (Leerräume ohne Umbruchzeichen ohne Tabulator)");
            add ("item","line_separator (XML-Export)");
            add ("item","paragraph-separator (XML-Export)");
            add ("item","symbol");
            add ("item","math_symbol");
            add ("item","currency_symbol (Währungssymbole)");
            add ("item","modifier_symbol (Bedeutungsverändernde Symbole wie Akzente)");
            add ("item","other_symbol");
            add ("item","number (alle Ziffern)");
            add ("item","decimal_digit_number (Ziffern von 0-9)");
            add ("item","letter_number (Römische Ziffern mit den Codepoints 2150-218F)");
            add ("item","other_numbers (hoch- und tiefgestellte Ziffern und Brüche)");
            add ("item","punctation (Satzzeichen Striche Anführungszeichen)");
            add ("item","dash_punctuation (ohne Trennstriche)");
            add ("item","open_puntuation");
            add ("item","close_punctuation");
            add ("item","initial_punctuation (öffnende Anführungszeichen aber keine Zollzeichen)");
            add ("item","final_punctuation (schließende Anführungszeichen aber keine Zollzeichen)");
            add ("item","other_punctuation");
          }   
        } // END tree _wildcardsForFindTree
      
        var _buttonGroup = add ("group");
        with (_buttonGroup) {
          var _close = add ("button", undefined, "Schließen", {name: "cancel"});
          var _insert = add ("button", undefined, "Einfügen", {name: "ok"});     
        }
      } // END dialog _selectWildcardsForFind
      
      var _insertWildcardForFind = _selectWildcardsForFind.show ();

      if (_insertWildcardForFind == 1 && _wildcardsForFindTree.selection != null && _wildcardsForFind[_wildcardsForFindTree.selection.text]!=null) {
        return _wildcardsForFind[_wildcardsForFindTree.selection.text]; 
      } else {
        return "";
      }
    } // END function __getWildcardsForFind
  
  
    function __getWildcardsForChange() {
  
      // Wildcard Object for Change
      var _wildcardsForChange = {
        "Tabulator": "\\t", 
        "Harter Zeilenumbruch": "\\n",
        "Absatzende": "\\r",
        "Aufzählungszeichen":"~8",
        "Caret-Zeichen":"\\^",
        "Copyright-Symbol":"~2",
        "Auslassungszeichen (Ellipse)":"~e",
        "Absatzmarke":"~7",
        "Eingetragene Marke":"~r",
        "Paragraphenzeichen":"~6",
        "Trademark-Symbol":"~d",
        "Aktuelle Seitenzahl":"~N",
        "Nächste Seitenzahl":"~X",
        "Vorherige Seitenzahl":"~V",
        "Abschnittsmarke":"~x",
        "Geviertstrich":"~_",
        "Halbgeviertstrich":"~=",
        "Bindestrich":"\\-",
        "Bedingter Trennstrich":"~-",
        "Geschützter Trennstrich":"~~",
        "Geviert":"~m",
        "Halbgeviert":"~>",
        "Drittelgeviert":"~3",
        "Viertelgeviert":"~4",
        "Sechstelgeviert":"~%",
        "Achtelgeviert":"~<",
        "Ausgleichsleerzeichen":"~f",
        "1/24-Geviert":"~|",
        "Geschützes Leerzeichen":"~S",
        "Geschütztes Leerzeichen (feste Breite)":"~s",
        "Interpunktionsleerzeichen":"~.",
        "Ziffernleerzeichen":"~/",
        "Gerades doppeltes Anführungszeichen":"~\"",
        "Öffnendes doppeltes Anführungszeichen":"~{",
        "Schließendes doppeltes Anführungszeichen":"~}",
        "Gerades einfaches Anführungszeichen (Apostroph)":"~\'",
        "Öffnendes einfaches Anführungszeichen":"~[",
        "Schließendes einfaches Anführungszeichen":"~]",
        "Standardzeilenumbruch":"~b",
        "Spaltenumbruch":"~M",
        "Rahmenumbruch":"~R",
        "Seitenumbruch":"~P",
        "Umbruch für ungerade Seiten":"~L",
        "Umbruch für gerade Seiten":"~E",
        "Bedingter Zeilenumbruch":"~k", 
        "Tabulator für rechte Ausrichtung":"~y",
        "Einzug bis hierhin":"~i",
        "Verschachteltes Format beenden":"~h",
        "Verbindung unterdrücken":"~j",
        "Inhalt der Zwischenablage (formatiert)":"~c",
        "Inhalt der Zwischenablage (unformatiert)":"~C",
        "Text gefunden":"$$0",
        "1 Stelle gefunden":"$$1",
        "2 Stelle gefunden":"$$2",
        "3 Stelle gefunden":"$$3",
        "4 Stelle gefunden":"$$4",
        "5 Stelle gefunden":"$$5",
        "6 Stelle gefunden":"$$6",
        "7 Stelle gefunden":"$$7",
        "8 Stelle gefunden":"$$8",
        "9 Stelle gefunden":"$$9"
      }
      
      // Wildcards Dialog for Change
      var _selectWildcardsForChange = new Window ("dialog","Sonderzeichen für Suche");
      with (_selectWildcardsForChange) {
        alignChildren = "right";
        var _wildcardsForChangeTree = add ("treeview");
        with (_wildcardsForChangeTree) {
          preferredSize = [350,260];
          itemSize = [560,20];
          
          add ("item","Tabulator"); 
          add ("item","Harter Zeilenumbruch");
          add ("item","Absatzende");

          // Symbole
          var _symbols = add ("node", "Symbole");
          with (_symbols) {
            add ("item","Aufzählungszeichen");
            add ("item","Caret-Zeichen");
            add ("item","Copyright-Symbol");
            add ("item","Auslassungszeichen (Ellipse)");
            add ("item","Absatzmarke");
            add ("item","Eingetragene Marke");
            add ("item","Paragraphenzeichen");
            add ("item","Trademark-Symbol");
          } 

          // Marken
          var _marks = add ("node","Marken");
          with (_marks) {
            add ("item","Aktuelle Seitenzahl");
            add ("item","Nächste Seitenzahl");
            add ("item","Vorherige Seitenzahl");
            add ("item","Abschnittsmarke");
          }

          // Trenn- und Gedankenstriche
          var _dashes = add ("node","Trenn- und Gedankenstriche");
          with (_dashes) {
            add ("item","Geviertstrich");
            add ("item","Halbgeviertstrich");
            add ("item","Bindestrich");
            add ("item","Bedingter Trennstrich");
            add ("item","Geschützter Trennstrich");
          }

          // Leerraum
          var _spaces = add ("node","Leerraum");
          with (_spaces) {
            add ("item","Geviert");
            add ("item","Halbgeviert");
            add ("item","Drittelgeviert");
            add ("item","Viertelgeviert");
            add ("item","Sechstelgeviert");
            add ("item","Achtelgeviert");
            add ("item","Ausgleichsleerzeichen");
            add ("item","1/24-Geviert");
            add ("item","Geschützes Leerzeichen");
            add ("item","Geschütztes Leerzeichen (feste Breite)");
            add ("item","Interpunktionsleerzeichen");
            add ("item","Ziffernleerzeichen");
          }

          // Anführungszeichen
          var _puntuation = add ("node","Anführungszeichen");
          with (_puntuation) {
            add ("item","Gerades doppeltes Anführungszeichen");
            add ("item","Öffnendes doppeltes Anführungszeichen");
            add ("item","Schließendes doppeltes Anführungszeichen");
            add ("item","Gerades einfaches Anführungszeichen (Apostroph)");
            add ("item","Öffnendes einfaches Anführungszeichen");
            add ("item","Schließendes einfaches Anführungszeichen");
          }

          // Umbruchzeichen
          var _breaks = add ("node","Umbruchzeichen");
          with (_breaks) {
            add ("item","Standardzeilenumbruch");
            add ("item","Spaltenumbruch");
            add ("item","Rahmenumbruch");
            add ("item","Seitenumbruch");
            add ("item","Umbruch für ungerade Seiten");
            add ("item","Umbruch für gerade Seiten");
            add ("item","Bedingter Zeilenumbruch");
          }

          // Andere
          var _others = add ("node","Andere");
          with (_others) { 
            add ("item","Tabulator für rechte Ausrichtung");
            add ("item","Einzug bis hierhin");
            add ("item","Verschachteltes Format beenden");
            add ("item","Verbindung unterdrücken");
            add ("item","Inhalt der Zwischenablage (formatiert)");
            add ("item","Inhalt der Zwischenablage (unformatiert)");
          }

          // Gefunden
          var _searchResults = add ("node","Gefunden");
          with (_searchResults) {
            add ("item","Text gefunden");
            add ("item","1 Stelle gefunden");
            add ("item","2 Stelle gefunden");
            add ("item","3 Stelle gefunden");
            add ("item","4 Stelle gefunden");
            add ("item","5 Stelle gefunden");
            add ("item","6 Stelle gefunden");
            add ("item","7 Stelle gefunden");
            add ("item","8 Stelle gefunden");
            add ("item","9 Stelle gefunden");
          }            
        } // END tree _wildcardsForChangeTree
      
        var _buttonGroup = add ("group");
        with (_buttonGroup) {
          var _close = add ("button", undefined, "Schließen", {name: "cancel"});
          var _insert = add ("button", undefined, "Einfügen", {name: "ok"});     
        }
      } // END dialog _selectWildcardsForChange
      
      var _insertWildcardForChange = _selectWildcardsForChange.show ();

      if (_insertWildcardForChange == 1 && _wildcardsForChangeTree.selection != null && _wildcardsForChange[_wildcardsForChangeTree.selection.text]!=null) {
        return _wildcardsForChange[_wildcardsForChangeTree.selection.text]; 
      } else {
        return "";
      }  
    } // END function __getWildcardsForChange
  

    function _getGrep (_condition, _findOrChange) { 
      
      // Hervorhebung (bedingeter Text) ist im Vorschau-Modus nicht sichtbar 
      app.activeDocument.layoutWindows[0].screenMode = ScreenModeOptions.previewOff;
      
      var _doc = app.activeDocument;
      var _input = _inputGrep.text;
      var _change = _changeGrep.text;
      var _place = _places.selection.text;
      
      switch (_place) {
        case "Textabschnitt" :
            try {
              _place = _doc.selection[0].insertionPoints[0].parentStory;
            } catch(e) { _place = null; /*alert("Place, Zuordnung, Textabschnitt: " + e + "Zeile: " + e.line);*/ }        
          break;
        case "Textrahmen" :
          try {
            _place = _doc.selection[0].insertionPoints[0].parentTextFrames[0];
          } catch(e) { _place = null; /*alert("Place, Zuordnung, Textrahmen: " + e + "Zeile: " + e.line);*/ }
          break;
        case "Tabellen" :
          try {
            _place = _doc.stories.everyItem().tables.everyItem();
          } catch(e) { _place = null; /*alert("Place, Zuordnung, Tabellen: " + e + "Zeile: " + e.line);*/ }
          break;
        case "Auswahl" :
          if (((app.selection.length > 0)&&(app.selection[0].constructor.name != "InsertionPoint"))&&
              ((app.selection[0].hasOwnProperty ("baseline"))||(app.selection[0].constructor.name == "TextFrame")||(app.selection[0].constructor.name == "Table"))) {    
            try {
              _place = app.selection[0];
            } catch(e) { _place = null; /*alert("Place, Zuordnung, Auswahl: " + e + "Zeile: " + e.line);*/ }
          } else { _place = null; } 
          break;      
        default :
          _place = _doc;
      }    
      
      if (_condition && (_place != null)) {
        var _findCharacterStyle = _findCharacterStyles.selection.text;
        if (_findCharacterStyle == "Zeichenformat: leer") {
          _findCharacterStyle = "";
        } else {
          if (app.activeDocument.characterStyles.itemByLabel(_findCharacterStyle)!=null) {
            _findCharacterStyle = app.activeDocument.characterStyles.itemByLabel(_findCharacterStyle);
          } else {
            alert ("Das Zeichenformat \"" + _findCharacterStyle + "\" ist nicht (mehr) vorhanden!\rBitte aktualisieren Sie die Formate durch Clicken auf den Refresh-Button.");
            _findCharacterStyle = "";       
          }  
        }
        var _findParagraphStyle = _findParagraphStyles.selection.text;
        if (_findParagraphStyle == "Absatzformat: leer") {
          _findParagraphStyle = "";
        } else {
          if (app.activeDocument.paragraphStyles.itemByLabel(_findParagraphStyle)!=null) {
            _findParagraphStyle = app.activeDocument.paragraphStyles.itemByLabel(_findParagraphStyle);  
          } else {
            alert ("Das Absatzformat \"" + _findParagraphStyle + "\" ist nicht (mehr) vorhanden!\rBitte aktualisieren Sie die Formate durch Clicken auf den Refresh-Button.");
            _findParagraphStyle = "";  
          }
        }        
        if (_findOrChange == "change") {
          var _changeCharacterStyle = _changeCharacterStyles.selection.text;
          if (_changeCharacterStyle == "Zeichenformat: leer") {
            _changeCharacterStyle = "";
          } else {    
            if (app.activeDocument.characterStyles.itemByLabel(_changeCharacterStyle)!=null) {
              _changeCharacterStyle = app.activeDocument.characterStyles.itemByLabel(_changeCharacterStyle);
            } else {
              alert ("Das Zeichenformat \"" + _changeCharacterStyle + "\" ist nicht (mehr) vorhanden!\rBitte aktualisieren Sie die Formate durch Clicken auf den Refresh-Button.");
              _changeCharacterStyle = _findCharacterStyle; 
            }  
          }
          var _changeParagraphStyle = _changeParagraphStyles.selection.text;
          if (_changeParagraphStyle == "Absatzformat: leer") {
            _changeParagraphStyle = "";
          } else {
            if (app.activeDocument.paragraphStyles.itemByLabel(_changeParagraphStyle)!=null) {
             _changeParagraphStyle = app.activeDocument.paragraphStyles.itemByLabel(_changeParagraphStyle); 
            } else {
              alert ("Das Absatzformat \"" + _changeParagraphStyle + "\" ist nicht (mehr) vorhanden!\rBitte aktualisieren Sie die Formate durch Clicken auf den Refresh-Button.");
              _changeParagraphStyle = _findParagraphStyle;  
            }  
          } 
        } else {   
          _change = "";
          _changeCharacterStyle = "";
          _changeParagraphStyle = ""; 
        }
        
        _searchOption = [_hiddenLayers.value, _masterPages.value, _footnotes.value];
        
        if ((_input != "")||(_findCharacterStyle!= "")||(_findParagraphStyle!= "")) {
          var _hits = findChangeGrep (_findOrChange, _input, _change, _findCharacterStyle, _changeCharacterStyle, _findParagraphStyle, _changeParagraphStyle, _place, _searchOption);
        } else {
          delConditions ();
        }
      } else {
        delConditions (); 
      }
      return _hits;
    }
  } // end if _palette==null /* refresh UI */ 
  return _palette;
}


function findChangeGrep (_findOrChange, _grep, _change, _findCharacterStyle, _changeCharacterStyle, _findParagraphStyle, _changeParagraphStyle, _place, _searchOption) {
  
  var _doc = app.activeDocument;
  var _hits = 0;
  
  if (_doc.conditions.itemByName("::Highlight_GREP::").isValid) {
    _highlightColor = _doc.conditions.itemByName("::Highlight_GREP::").indicatorColor;
    _highlightMethod = _doc.conditions.itemByName("::Highlight_GREP::").indicatorMethod;
  }  
  
  delConditions ();

  if (!_doc.conditions.itemByName("::Highlight_GREP::").isValid) {
    _doc.conditions.add ({name: "::Highlight_GREP::", indicatorColor: _highlightColor, indicatorMethod: _highlightMethod});
  }
  
  var _highlightCondition = [_doc.conditions.itemByName ("::Highlight_GREP::")]; 
  var _findChangeResults = findChange (_findOrChange, _grep, _change, _findCharacterStyle, _changeCharacterStyle, _findParagraphStyle, _changeParagraphStyle, _place, _highlightCondition, _searchOption);

  if ((_findChangeResults.length > 0) && (_findChangeResults[0].constructor.name == "Array")) { 
    var _hitcounter = 0;
    for (var i=0; i<_findChangeResults.length; i++) {
      for (var j=0; j<_findChangeResults[i].length; j++) {
        _hitcounter += 1;
      }   
    }    
    _hits = _hitcounter;   
  } else { 
    _hits = _findChangeResults.length;
  }  
  return _hits; 
}


function delConditions () {
  
  if (app.activeDocument.conditions.itemByName("::Highlight_GREP::").isValid) {
    app.activeDocument.conditions.itemByName("::Highlight_GREP::").remove ();
  }
}


function delConditionsInAllDocs () {
  
  for (var d = 0; d < app.documents.length; d++) {
    if (app.documents[d].conditions.itemByName("::Highlight_GREP::").isValid) {
      app.documents[d].conditions.itemByName("::Highlight_GREP::").remove ();
    }
  }
}


function findChange (_findOrChange, _find, _change, _findCharacterStyle, _changeCharacterStyle, _findParagraphStyle, _changeParagraphStyle, _place, _highlightCondition, _searchOption) {
  
  with (app) {   
    with (findChangeGrepOptions) {   
      //User-Einstellungen speichern
      var _userIncludeFootnotes = includeFootnotes;
      var _userIncludeHiddenLayers = includeHiddenLayers;
      var _userIncludeLockedLayersForFind = includeLockedLayersForFind;
      var _userIncludeLockedStoriesForFind = includeLockedStoriesForFind;
      var _userIncludeMasterPages = includeMasterPages;
      //Einstellungen setzen
      includeFootnotes = _searchOption[2];
      includeHiddenLayers = _searchOption[0];
      includeLockedLayersForFind = false; 
      includeLockedStoriesForFind = false; 
      includeMasterPages = _searchOption[1];     
    }  
  
    findGrepPreferences = NothingEnum.nothing;
    changeGrepPreferences = NothingEnum.nothing;
    
    with (findGrepPreferences) {
      findWhat = _find;
      appliedCharacterStyle = _findCharacterStyle;
      appliedParagraphStyle = _findParagraphStyle;
    }
    
    with (changeGrepPreferences) {
      changeTo = _change;  
      appliedCharacterStyle = _changeCharacterStyle;
      appliedParagraphStyle = _changeParagraphStyle;      
      changeConditionsMode = ChangeConditionsModes.ADD_TO; 
      if (_findOrChange == "change" && _change == "") {
        appliedConditions = NothingEnum.nothing;
      } else {
        appliedConditions = _highlightCondition; 
      }    
    }
     
    try {
      _results = _place.changeGrep(true);  
    } catch(e) { 
      /*alert("Place, changeGrep: " + e + "Zeile: " + e.line);*/ 
    }    
    
    findGrepPreferences = NothingEnum.nothing;
    changeGrepPreferences = NothingEnum.nothing;
    
    with (findChangeGrepOptions) {     
      //User-Einstellungen wieder herstellen
      includeFootnotes = _userIncludeFootnotes;
      includeHiddenLayers = _userIncludeHiddenLayers;
      includeLockedLayersForFind = _userIncludeLockedLayersForFind;
      includeLockedStoriesForFind = _userIncludeLockedStoriesForFind;
      includeMasterPages = _userIncludeMasterPages;    
    } 
  }
  return _results;
}

function findHits () {
  
  var _place = app.activeDocument;
  var _highlightCondition;
  var _results = [];
  if (app.activeDocument.conditions.itemByName("::Highlight_GREP::").isValid) {
    _highlightCondition = [app.activeDocument.conditions.itemByName("::Highlight_GREP::")];
  } else {
    _highlightCondition = NothingEnum.nothing;
  } 

  with (app) {   
    with (findChangeGrepOptions) {   
      //User-Einstellungen speichern
      var _userIncludeFootnotes = includeFootnotes;
      var _userIncludeHiddenLayers = includeHiddenLayers;
      var _userIncludeLockedLayersForFind = includeLockedLayersForFind;
      var _userIncludeLockedStoriesForFind = includeLockedStoriesForFind;
      var _userIncludeMasterPages = includeMasterPages;
      //Einstellungen setzen
      includeFootnotes = true;
      includeHiddenLayers = true;
      includeLockedLayersForFind = true;
      includeLockedStoriesForFind = true;
      includeMasterPages = true;     
    }  
  
    findGrepPreferences = NothingEnum.nothing;
    changeGrepPreferences = NothingEnum.nothing;  
    
    with (findGrepPreferences) {
      appliedConditions = _highlightCondition;
    }
     
    try {
      _results = _place.findGrep();  
    } catch(e) { /*alert("Place, findGrep: " + e + "Zeile: " + e.line);*/ }    
    
    findGrepPreferences = NothingEnum.nothing;
    changeGrepPreferences = NothingEnum.nothing;
    
    with (findChangeGrepOptions) {     
      //User-Einstellungen wieder herstellen
      includeFootnotes = _userIncludeFootnotes;
      includeHiddenLayers = _userIncludeHiddenLayers;
      includeLockedLayersForFind = _userIncludeLockedLayersForFind;
      includeLockedStoriesForFind = _userIncludeLockedStoriesForFind;
      includeMasterPages = _userIncludeMasterPages;    
    } 
  }
  return _results;
}


// function filePath by Peter Kahrel -- www.kahrel.plus.com 
function filePath () {
	try {return File (app.activeScript).path}
    catch(e) {return File (e.fileName).path}
	}

  
// function showIt von Gregor Fellenz: www.indd-skript.de
// showIt() zeigt das übergebene Objekt an
function showIt (_object) {
	if (_object != null && app.documents.length > 0 && app.layoutWindows.length > 0 ) {
		app.activeWindow.activeSpread = getSpreadByObject (_object);
		app.select(_object);
		var myZoom = app.activeWindow.zoomPercentage; 
		app.activeWindow.zoom(ZoomOptions.showPasteboard); 
		app.activeWindow.zoomPercentage = myZoom;
		return true;
	}
	else {
		return false;
	}
}


// function getSpreadByObject von Gregor Fellenz: www.indd-skript.de
// Liefert den Druckbogen, auf dem sich das Objekt befindet
function  getSpreadByObject (_object) {
	if (_object != null) {
		_object = _object.getElements ()[0]; // Problems with Baseclass Objects like PageItem in  CS5!
		if (_object.hasOwnProperty("baseline")) {
			_object = _object.parentTextFrames[0];
		}
		while (_object != null) {
			var whatIsIt = _object.constructor;
			switch (whatIsIt) {
				case Spread : return _object;
				case Character : _object = _object.parentTextFrames[0]; break;
				case Footnote :; // drop through
				case Cell : _object = _object.insertionPoints[0].parentTextFrames[0]; break;
				case Note : _object = _object.storyOffset.parentTextFrames[0]; break;
				case XMLElement : if (_object.insertionPoints[0] != null) { _object = _object.insertionPoints[0].parentTextFrames[0]; break; }
				case Application : return null;
				default: _object = _object.parent;
			}
			if (_object == null) return null;
		}
		return _object;
			} 
	else {
		return null;
	}
}


// Neue Methode "itemByLabel" fuer CharacterStyles und ParagraphStyles
function prototypeItemByLabel () {

  Object.prototype.itemByLabel=function(_label) { 
      
    var _styles = [];
    var _result = null;
    
    switch (this.constructor.name) {
      case "CharacterStyles" :
        _styles = app.activeDocument.allCharacterStyles;
        break;
      case "ParagraphStyles" :
        _styles = app.activeDocument.allParagraphStyles;
        break;
      default :
        _result = null;
    }
      
    for (var i=0; i<_styles.length; i++) {    
      if (_styles[i].label == _label) {
        _result = _styles[i];
      }     
    }     
    return _result; 
  } 
}


// Warnmeldung falls im Dokument bereits Bedingungen fuer bedingten Text vorhanden sind.
function alertConditionalText () {  
  do {
  if (_alertCounter == true && _lastDoc == app.activeDocument) break;
  if (app.activeDocument.conditions.length == 0) break;
  if (app.activeDocument.conditions.length == 1 && app.activeDocument.conditions.itemByName("::Highlight_GREP::").isValid) break; 
  var _continue = confirm ("Vorsicht!\rSie arbeiten in Ihrem Dokument mit \"bedingtem Text\".\r\rIn bestimmten Fällen können die \"Bedingungen\" durch die Suche dieses Skipts überschrieben werden.\r\rTrotzdem Fortfahren?");
  _alertCounter = true;
  _lastDoc = app.activeDocument.getElements()[0];
  if (!_continue) exit();
  } while (false)
  return _continue;
}