﻿//DESCRIPTION: Load EPUB Presets ... 
/*  
@Version: 1.0
@Date: 2015-02-05
@Author: Gregor Fellenz
http://www.publishingx.de
*/

startProcessing();

function startProcessing () {
	if (app.documents.length == 0 ) {
		alert ("No document is open!");
		return;		
	}
	
	var dok = app.documents[0];	
	var scriptPath = getScriptFolderPath ();
	var epubPresetPath = Folder (scriptPath + "/epub_presets");

	if (!epubPresetPath.exists) {
		alert ("Could not read folder [epub_presets] with the presets!");
		return;
	}
	var epubPresetFiles = epubPresetPath.getFiles ("*.epuboptions");
	if (epubPresetFiles.length == 0) {
		alert ("Please save presets first!");
		return;
	}
	for (var i = 0; i < epubPresetFiles.length; i++) {
		epubPresetFiles[i] = unescape (epubPresetFiles[i].name.replace(/.epuboptions/, ""));
	}

	var epubPresetName = getPresetName(epubPresetFiles);
	if (!epubPresetName) {
		// User canceled
		return;
	}
	var epubPresetNameFile = File ( epubPresetPath + "/" + escape (epubPresetName) + ".epuboptions");
	var epubPresetJSON = readTextFile(epubPresetNameFile);
	epubPresetObject = eval(epubPresetJSON);
	
	if (epubPresetName.match (/_reflow$/)) {
		dok.epubExportPreferences.properties = epubPresetObject;
	}
	else if (dok.hasOwnProperty ("epubFixedLayoutExportPreferences") && epubPresetName.match (/_fixed$/)) {
		dok.epubFixedLayoutExportPreferences.properties = epubPresetObject;
	}
	else {
		alert("Could not determine preset type");
	}
}

function getPresetName(epubPresetFiles) {
	var presetName = "";
	var win = new Window("dialog", "Select an EPUB Preset");
	with (win) {	
		win.presetDropDown = add( "DropDownList", undefined, epubPresetFiles);
		win.presetDropDown.selection = 0;
		win.presetDropDown.preferredSize.width = 250;
		
		win.groupControl = add("group");
		win.groupControl.preferredSize.width = 250;
		win.groupControl.alignChildren = ['right', 'center'];
		win.groupControl.margins = 0;
		with (win.groupControl) {
			win.groupControl.butOk = add( "button", undefined, "Ok");
			win.groupControl.butCancel = add( "button", undefined, "Cancel");
		}
		win.groupControl.butOk.onClick = function() {
			presetName = win.presetDropDown.selection.toString ();
			win.close(1);
		}
		win.groupControl.butCancel.onClick = function() {
			win.close(2);
		}
	}
	win.center();
	var result = win.show();
	if (result == 2) return false;
	else return presetName;
}

/** Get Filepath from current script  */
/*Folder*/ function getScriptFolderPath() {
	try {
		skriptPath  = app.activeScript.parent;
	} 
	catch (e) { 
		/* We're running from the ESTK*/
		skriptPath = File(e.fileName).parent;
	}
	return skriptPath;
}

function trim (string) {
	string = string.replace(/^\s+/g,"");
	string = string.replace(/\s+$/g,"");
	return string;
}

function readTextFile (_file, _encoding) {
	if (_file.constructor.name == "File" && _file.exists) {
		try {
			if (_encoding != undefined) _file.encoding = _encoding;
			_file.open("r");
			var _res = _file.read(); 
			_file.close();
			return _res;
		} catch (e) {return e}
	} 
	else {
		return Error ("This is not a File");
	}
}
/**
* Writes a String to a UTF-8 encoded File
* @param {File} _file The File
* @param {String} _string The String to write
* @return {Bool} <b>true</b> everything worked fine, {Error} something went wrong
*/
function writeTextFile (_file, _string) {
	if (_file.constructor.name == "String") {
		_file = new File(_file);
	}
	if (_file.constructor.name == "File") {
		try {
			_file.encoding = "UTF-8";
			_file.open( "w" );
			_file.write (_string);
			_file.close ();
			return true;
		} catch (e) {return e}
	} 
	else {
		return Error ("This is not a File");
	}
}