﻿//DESCRIPTION: Export EPUB Presets ... 
/*  
@Version: 1.0
@Date: 2015-02-05
@Author: Gregor Fellenz
http://www.publishingx.de
*/

startProcessing();

function startProcessing () {
	if (app.documents.length == 0 ) {
		alert ("No document is open!");
		return;		
	}
	
	var dok = app.documents[0];	
	var scriptPath = getScriptFolderPath ();
	var epubPresetPath = Folder (scriptPath + "/epub_presets");
	if (!epubPresetPath.exists) {
		epubPresetPath.create();
	}
	if (!epubPresetPath.exists) {
		alert ("Could not create folder [epub_presets] for saving the presets!");
		return;
	}
	var epubPresetName = getPresetName();
	if (!epubPresetName) {
		// User canceled
		return;
	}
	var epubPresetNameFile = File ( epubPresetPath + "/" + epubPresetName + "_reflow.epuboptions");
	if (epubPresetNameFile.exists) {
		if (!confirm ("Preset " + epubPresetName + "_reflow exists, overwrite?")) return;
	}
	var epubPresetObject = createObject(dok.epubExportPreferences);
	var epubPresetJSON = epubPresetObject.toSource().replace(/\r/g,"\\r");
	writeTextFile (epubPresetNameFile, epubPresetJSON);
	
	if (dok.hasOwnProperty ("epubFixedLayoutExportPreferences")) {
		epubPresetNameFile = File ( epubPresetPath + "/" + epubPresetName + "_fixed.epuboptions");
		if (epubPresetNameFile.exists) {
			if (!confirm ("Preset " + epubPresetName + "_fixed exists, overwrite?")) return;
		}
		epubPresetObject = createObject(dok.epubFixedLayoutExportPreferences);
		epubPresetJSON = epubPresetObject.toSource().replace(/\r/g,"\\r");
		writeTextFile (epubPresetNameFile, epubPresetJSON);
	}
}

function getPresetName() {
	var presetName = "";
	var win = new Window("dialog", "EPUB Preset name");
	with (win) {
		win.eTextFolder = add( "edittext");
		win.eTextFolder.text = presetName;
		win.eTextFolder.preferredSize.width = 250;
		
		win.groupControl = add("group");
		win.groupControl.preferredSize.width = 250;
		win.groupControl.alignChildren = ['right', 'center'];
		win.groupControl.margins = 0;
		with (win.groupControl) {
			win.groupControl.butOk = add( "button", undefined, "Ok");
			win.groupControl.butCancel = add( "button", undefined, "Cancel");
		}
		win.groupControl.butOk.onClick = function() {
			presetName = trim(win.eTextFolder.text);
			if (presetName == "") {
				alert ("No valid Preset name!");
				return;
			}
			win.close(1);
		}
		win.groupControl.butCancel.onClick = function() {
			win.close(2);
		}
	}
	win.center();
	var result = win.show();
	if (result == 2) return false;
	else return presetName;
}

// Objekt einlesen, damit es mit toSource() ausgewertet werden kann.
function createObject (object) {
	if (object == null) return null;
	if (object == undefined) return undefined;
	if( object.hasOwnProperty("properties") ) {
		object = object.properties;
		delete object.index;
		delete object.id;
		delete object.parent;
		delete object.events;
		delete object.eventListeners;
		delete object.isValid;
		delete object.level;
				
		for ( var property in object ) {		
			object[property] = createObject(object[property]);
		}
	} else if ( object.constructor.name == "Enumerator" ) {
		object = object.valueOf();
	}
	return object;
}

/** Get Filepath from current script  */
/*Folder*/ function getScriptFolderPath() {
	try {
		skriptPath  = app.activeScript.parent;
	} 
	catch (e) { 
		/* We're running from the ESTK*/
		skriptPath = File(e.fileName).parent;
	}
	return skriptPath;
}

function trim (string) {
	string = string.replace(/^\s+/g,"");
	string = string.replace(/\s+$/g,"");
	return string;
}

function readTextFile (_file, _encoding) {
	if (_file.constructor.name == "File" && _file.exists) {
		try {
			if (_encoding != undefined) _file.encoding = _encoding;
			_file.open("r");
			var _res = _file.read(); 
			_file.close();
			return _res;
		} catch (e) {return e}
	} 
	else {
		return Error ("This is not a File");
	}
}
/**
* Writes a String to a UTF-8 encoded File
* @param {File} _file The File
* @param {String} _string The String to write
* @return {Bool} <b>true</b> everything worked fine, {Error} something went wrong
*/
function writeTextFile (_file, _string) {
	if (_file.constructor.name == "String") {
		_file = new File(_file);
	}
	if (_file.constructor.name == "File") {
		try {
			_file.encoding = "UTF-8";
			_file.open( "w" );
			_file.write (_string);
			_file.close ();
			return true;
		} catch (e) {return e}
	} 
	else {
		return Error ("This is not a File");
	}
}